/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.Constants;
import com.github.pjfanning.poi.xssf.streaming.TextParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.SstDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileSharedStringsTable
extends SharedStringsTable {
    private static final Logger log = LoggerFactory.getLogger(TempFileSharedStringsTable.class);
    private static final QName COUNT_QNAME = new QName("count");
    private static final QName UNIQUE_COUNT_QNAME = new QName("uniqueCount");
    private File tempFile;
    private MVStore mvStore;
    private final boolean fullFormat;
    private final MVMap<Integer, CTRst> strings;
    private final MVMap<String, Integer> stmap;
    private static final XmlOptions siSaveOptions = new XmlOptions(Constants.saveOptions);

    public TempFileSharedStringsTable() {
        this(false, false);
    }

    public TempFileSharedStringsTable(boolean encryptTempFiles) {
        this(encryptTempFiles, false);
    }

    public TempFileSharedStringsTable(boolean encryptTempFiles, boolean fullFormat) {
        this.fullFormat = fullFormat;
        try {
            this.tempFile = TempFile.createTempFile((String)"poi-shared-strings", (String)".tmp");
            MVStore.Builder mvStoreBuilder = new MVStore.Builder();
            if (encryptTempFiles) {
                byte[] bytes = new byte[1024];
                Constants.RANDOM.nextBytes(bytes);
                mvStoreBuilder.encryptionKey(Base64.getEncoder().encodeToString(bytes).toCharArray());
            }
            mvStoreBuilder.fileName(this.tempFile.getAbsolutePath());
            this.mvStore = mvStoreBuilder.open();
            this.strings = this.mvStore.openMap("strings");
            this.stmap = this.mvStore.openMap("stmap");
        }
        catch (Error | RuntimeException e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw new RuntimeException(e);
        }
    }

    public TempFileSharedStringsTable(OPCPackage pkg, boolean encryptTempFiles) throws IOException {
        this(pkg, encryptTempFiles, false);
    }

    public TempFileSharedStringsTable(OPCPackage pkg, boolean encryptTempFiles, boolean fullFormat) throws IOException {
        this(encryptTempFiles, fullFormat);
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (parts.size() > 0) {
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFrom(InputStream is) throws IOException {
        try {
            int uniqueCount = -1;
            int count = -1;
            try (XMLEventReader xmlEventReader = Constants.XML_INPUT_FACTORY.createXMLEventReader(is);){
                while (xmlEventReader.hasNext()) {
                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                    if (!xmlEvent.isStartElement()) continue;
                    StartElement startElement = xmlEvent.asStartElement();
                    QName startTag = startElement.getName();
                    String localPart = startTag.getLocalPart();
                    if (localPart.equals("sst")) {
                        try {
                            Attribute countAtt = startElement.getAttributeByName(COUNT_QNAME);
                            if (countAtt != null) {
                                count = Integer.parseInt(countAtt.getValue());
                            }
                        }
                        catch (Exception e) {
                            log.warn("Failed to parse SharedStringsTable count");
                        }
                        try {
                            Attribute uniqueCountAtt = startElement.getAttributeByName(UNIQUE_COUNT_QNAME);
                            if (uniqueCountAtt == null) continue;
                            uniqueCount = Integer.parseInt(uniqueCountAtt.getValue());
                            continue;
                        }
                        catch (Exception e) {
                            log.warn("Failed to parse SharedStringsTable uniqueCount");
                            continue;
                        }
                    }
                    if (!localPart.equals("si")) continue;
                    if (this.fullFormat) {
                        CTSst sst;
                        List<String> tags = Arrays.asList("sst", "si");
                        String text = TextParser.getXMLText(xmlEventReader, startTag, tags);
                        try {
                            sst = ((SstDocument)SstDocument.Factory.parse(text)).getSst();
                        }
                        catch (XmlException e) {
                            throw new IOException("Failed to parse shared string text", e);
                        }
                        this.addEntry(new XSSFRichTextString(sst.getSiArray(0)).getCTRst(), true);
                        continue;
                    }
                    String text = TextParser.parseCT_Rst(xmlEventReader);
                    this.addEntry(new XSSFRichTextString(text).getCTRst(), true);
                }
                if (count > -1) {
                    this.count = count;
                }
                if (uniqueCount <= -1) return;
                if (uniqueCount != this.uniqueCount) {
                    log.warn("SharedStringsTable has uniqueCount={} but read {} entries. This will probably cause some cells to be misinterpreted.", (Object)uniqueCount, (Object)this.uniqueCount);
                }
                this.uniqueCount = uniqueCount;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to parse shared strings", e);
        }
    }

    private CTRst getEntryAt(int idx) {
        CTRst rst = (CTRst)this.strings.get((Object)idx);
        if (rst == null) {
            throw new NoSuchElementException();
        }
        return rst;
    }

    public RichTextString getItemAt(int idx) {
        return new XSSFRichTextString(this.getEntryAt(idx));
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    private int addEntry(CTRst st, boolean keepDuplicates) {
        if (st == null) {
            throw new NullPointerException("Cannot add null entry to SharedStringsTable");
        }
        String s = this.xmlText(st);
        ++this.count;
        if (!keepDuplicates && this.stmap.containsKey((Object)s)) {
            return (Integer)this.stmap.get((Object)s);
        }
        int idx = this.uniqueCount++;
        this.stmap.put((Object)s, (Object)idx);
        this.strings.put((Object)idx, (Object)st);
        return idx;
    }

    public int addSharedStringItem(RichTextString string) {
        if (!(string instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        return this.addEntry(((XSSFRichTextString)string).getCTRst(), false);
    }

    public List<RichTextString> getSharedStringItems() {
        throw new UnsupportedOperationException("TempFileSharedStringsTable only supports streaming access of shared strings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        try {
            writer.write("<sst count=\"");
            writer.write(Integer.toString(this.count));
            writer.write("\" uniqueCount=\"");
            writer.write(Integer.toString(this.uniqueCount));
            writer.write("\" xmlns=\"");
            writer.write("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            writer.write("\">");
            for (CTRst rst : this.strings.values()) {
                writer.write(rst.xmlText(siSaveOptions));
            }
            writer.write("</sst>");
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    public void close() throws IOException {
        if (this.mvStore != null) {
            this.mvStore.closeImmediately();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    static {
        siSaveOptions.setSaveSyntheticDocumentElement(new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "si"));
    }
}

