/*
 * Decompiled with CFR 0.152.
 */
package psiprobe;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.core.authority.mapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.MappableAttributesRetriever;
import org.springframework.security.core.authority.mapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesUserDetailsService;
import org.springframework.security.web.authentication.preauth.j2ee.J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.j2ee.J2eePreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.j2ee.WebXmlMappableAttributesRetriever;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class ProbeSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Bean(name={"filterChainProxy"})
    public FilterChainProxy getFilterChainProxy() {
        DefaultSecurityFilterChain chain = new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/**"), new Filter[]{this.getSecurityContextPersistenceFilter(), this.getJ2eePreAuthenticatedProcessingFilter(), this.getLogoutFilter(), this.getExceptionTranslationFilter(), this.getFilterSecurityInterceptor()});
        return new FilterChainProxy((SecurityFilterChain)chain);
    }

    @Bean(name={"authenticationManager"})
    public ProviderManager getProviderManager() {
        ArrayList<PreAuthenticatedAuthenticationProvider> providers = new ArrayList<PreAuthenticatedAuthenticationProvider>();
        providers.add(this.getPreAuthenticatedAuthenticationProvider());
        return new ProviderManager(providers);
    }

    @Bean(name={"sif"})
    public SecurityContextPersistenceFilter getSecurityContextPersistenceFilter() {
        return new SecurityContextPersistenceFilter();
    }

    @Bean(name={"preAuthenticatedAuthenticationProvider"})
    public PreAuthenticatedAuthenticationProvider getPreAuthenticatedAuthenticationProvider() {
        PreAuthenticatedAuthenticationProvider provider = new PreAuthenticatedAuthenticationProvider();
        provider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)this.getPreAuthenticatedGrantedAuthoritiesUserDetailsService());
        return provider;
    }

    @Bean(name={"preAuthenticatedUserDetailsService"})
    public PreAuthenticatedGrantedAuthoritiesUserDetailsService getPreAuthenticatedGrantedAuthoritiesUserDetailsService() {
        return new PreAuthenticatedGrantedAuthoritiesUserDetailsService();
    }

    @Bean(name={"j2eePreAuthenticatedProcessingFilter"})
    public J2eePreAuthenticatedProcessingFilter getJ2eePreAuthenticatedProcessingFilter() {
        J2eePreAuthenticatedProcessingFilter filter = new J2eePreAuthenticatedProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)this.getProviderManager());
        filter.setAuthenticationDetailsSource((AuthenticationDetailsSource)this.getJ2eeBasedPreAuthenticatedWebAuthenticationDetailsSource());
        return filter;
    }

    @Bean(name={"preAuthenticatedProcessingFilterEntryPoint"})
    public Http403ForbiddenEntryPoint getHttp403ForbiddenEntryPoint() {
        return new Http403ForbiddenEntryPoint();
    }

    @Bean(name={"logoutFilter"})
    public LogoutFilter getLogoutFilter() {
        return new LogoutFilter("/", new LogoutHandler[]{this.getSecurityContextLogoutHandler()});
    }

    @Bean(name={"securityContextLogoutHandler"})
    public SecurityContextLogoutHandler getSecurityContextLogoutHandler() {
        return new SecurityContextLogoutHandler();
    }

    @Bean(name={"authenticationDetailsSource"})
    public J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource getJ2eeBasedPreAuthenticatedWebAuthenticationDetailsSource() {
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource source = new J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource();
        source.setMappableRolesRetriever((MappableAttributesRetriever)this.getWebXmlMappableAttributesRetriever());
        source.setUserRoles2GrantedAuthoritiesMapper((Attributes2GrantedAuthoritiesMapper)this.getSimpleAttributes2GrantedAuthoritiesMapper());
        return source;
    }

    @Bean(name={"j2eeUserRoles2GrantedAuthoritiesMapper"})
    public SimpleAttributes2GrantedAuthoritiesMapper getSimpleAttributes2GrantedAuthoritiesMapper() {
        SimpleAttributes2GrantedAuthoritiesMapper mapper = new SimpleAttributes2GrantedAuthoritiesMapper();
        mapper.setConvertAttributeToUpperCase(true);
        return mapper;
    }

    @Bean(name={"j2eeMappableRolesRetriever"})
    public WebXmlMappableAttributesRetriever getWebXmlMappableAttributesRetriever() {
        return new WebXmlMappableAttributesRetriever();
    }

    @Bean(name={"etf"})
    public ExceptionTranslationFilter getExceptionTranslationFilter() {
        return new ExceptionTranslationFilter((AuthenticationEntryPoint)this.getHttp403ForbiddenEntryPoint());
    }

    @Bean(name={"httpRequestAccessDecisionManager"})
    public AffirmativeBased getAffirmativeBased() {
        ArrayList<RoleVoter> decisionVoters = new ArrayList<RoleVoter>();
        decisionVoters.add(this.getRoleVoter());
        AffirmativeBased based = new AffirmativeBased(decisionVoters);
        based.setAllowIfAllAbstainDecisions(false);
        return based;
    }

    @Bean(name={"fsi"})
    public FilterSecurityInterceptor getFilterSecurityInterceptor() {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAuthenticationManager((AuthenticationManager)this.getProviderManager());
        interceptor.setAccessDecisionManager((AccessDecisionManager)this.getAffirmativeBased());
        LinkedHashMap<AntPathRequestMatcher, List> requestMap = new LinkedHashMap<AntPathRequestMatcher, List>();
        requestMap.put(new AntPathRequestMatcher("/adm/**"), SecurityConfig.createListFromCommaDelimitedString((String)"ROLE_MANAGER,ROLE_MANAGER-GUI"));
        requestMap.put(new AntPathRequestMatcher("/adm/restartvm.ajax"), SecurityConfig.createListFromCommaDelimitedString((String)"ROLE_POWERUSERPLUS,ROLE_MANAGER,ROLE_MANAGER-GUI"));
        requestMap.put(new AntPathRequestMatcher("/sql/**"), SecurityConfig.createListFromCommaDelimitedString((String)"ROLE_POWERUSERPLUS,ROLE_MANAGER,ROLE_MANAGER-GUI"));
        requestMap.put(new AntPathRequestMatcher("/app/**"), SecurityConfig.createListFromCommaDelimitedString((String)"ROLE_POWERUSER,ROLE_POWERUSERPLUS,ROLE_MANAGER,ROLE_MANAGER-GUI"));
        requestMap.put(new AntPathRequestMatcher("/**"), SecurityConfig.createListFromCommaDelimitedString((String)"ROLE_PROBEUSER,ROLE_POWERUSER,ROLE_POWERUSERPLUS,ROLE_MANAGER,ROLE_MANAGER-GUI"));
        interceptor.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)new DefaultFilterInvocationSecurityMetadataSource(requestMap));
        return interceptor;
    }

    @Bean(name={"roleVoter"})
    public RoleVoter getRoleVoter() {
        return new RoleVoter();
    }

    @Bean(name={"securityContextHolderAwareRequestFilter"})
    public SecurityContextHolderAwareRequestFilter getSecurityContextHolderAwareRequestFilter() {
        return new SecurityContextHolderAwareRequestFilter();
    }

    @Bean(name={"httpSessionRequestCache"})
    public HttpSessionRequestCache getHttpSessionRequestCache() {
        HttpSessionRequestCache cache = new HttpSessionRequestCache();
        cache.setCreateSessionAllowed(false);
        return cache;
    }

    @Bean(name={"xstream"})
    public XStream getXstream() {
        XStream xstream = new XStream();
        XStream.setupDefaultSecurity((XStream)xstream);
        return xstream;
    }
}

