/*
 * Decompiled with CFR 0.152.
 */
package psiprobe;

import java.nio.charset.StandardCharsets;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.DispatcherServlet;
import psiprobe.beans.ContainerWrapperBean;

@WebServlet
public class ProbeServlet
extends DispatcherServlet
implements ContainerServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ProbeServlet.class);
    private transient Wrapper wrapper;

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        logger.info("setWrapper() called");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.wrapper == null) {
            throw new ServletException("Wrapper is null");
        }
        this.getContainerWrapperBean().setWrapper(this.wrapper);
    }

    protected void doDispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletRequest.setCharacterEncoding(StandardCharsets.UTF_8.name());
        super.doDispatch(httpServletRequest, httpServletResponse);
    }

    public void destroy() {
        this.getContainerWrapperBean().setWrapper(null);
        super.destroy();
    }

    protected ContainerWrapperBean getContainerWrapperBean() {
        return (ContainerWrapperBean)this.getWebApplicationContext().getBean("containerWrapper");
    }
}

