/*
 * Decompiled with CFR 0.152.
 */
package psiprobe;

import com.google.common.base.Strings;
import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XhtmlRendererFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.tokenizer.StringTokenizer;
import psiprobe.tokenizer.Token;
import psiprobe.tokenizer.Tokenizer;
import psiprobe.tokenizer.TokenizerSymbol;

public final class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static String readFile(File file, String charsetName) throws IOException {
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            String string = Utils.readStream(fis, charsetName);
            return string;
        }
    }

    public static String readStream(InputStream is, String charsetName) throws IOException {
        Charset charset = Charset.forName(System.getProperty("file.encoding"));
        if (Charset.isSupported(charsetName)) {
            charset = Charset.forName(charsetName);
        }
        StringBuilder out = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset), 4096);){
            String line;
            while ((line = reader.readLine()) != null) {
                out.append(line).append('\n');
            }
        }
        return out.toString();
    }

    public static void delete(File file) {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    Utils.delete(child);
                }
            }
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.debug("Cannot delete '{}'", (Object)file.getAbsolutePath(), (Object)e);
            }
        } else {
            logger.debug("'{}' does not exist", (Object)file);
        }
    }

    public static int toInt(String num, int defaultValue) {
        if (num != null && !num.contains(" ")) {
            try (Scanner scanner = new Scanner(num);){
                if (scanner.hasNextInt()) {
                    int n = Integer.parseInt(num);
                    return n;
                }
            }
        }
        return defaultValue;
    }

    public static int toIntHex(String num, int defaultValue) {
        if (num != null && !num.contains(" ")) {
            if (num.startsWith("#")) {
                num = num.substring(1);
            }
            try (Scanner scanner = new Scanner(num);){
                if (scanner.hasNextInt()) {
                    int n = Integer.parseInt(num, 16);
                    return n;
                }
            }
        }
        return defaultValue;
    }

    public static long toLong(String num, long defaultValue) {
        if (num != null && !num.contains(" ")) {
            try (Scanner scanner = new Scanner(num);){
                if (scanner.hasNextLong()) {
                    long l = Long.parseLong(num);
                    return l;
                }
            }
        }
        return defaultValue;
    }

    public static long toLong(Long num, long defaultValue) {
        return num == null ? defaultValue : num;
    }

    public static float toFloat(String num, float defaultValue) {
        if (num != null && !num.contains(" ")) {
            try (Scanner scanner = new Scanner(num);){
                if (scanner.hasNextFloat()) {
                    float f = Float.parseFloat(num);
                    return f;
                }
            }
        }
        return defaultValue;
    }

    public static String getJspEncoding(InputStream is) throws IOException {
        String encoding = null;
        String contentType = null;
        Tokenizer jspTokenizer = new Tokenizer();
        jspTokenizer.addSymbol("\n", true);
        jspTokenizer.addSymbol(" ", true);
        jspTokenizer.addSymbol("\t", true);
        jspTokenizer.addSymbol(new TokenizerSymbol("dir", "<%@", "%>", false, false, true, false));
        StringTokenizer directiveTokenizer = new StringTokenizer();
        directiveTokenizer.addSymbol("\n", true);
        directiveTokenizer.addSymbol(" ", true);
        directiveTokenizer.addSymbol("\t", true);
        directiveTokenizer.addSymbol("=");
        directiveTokenizer.addSymbol("\"", "\"", false);
        directiveTokenizer.addSymbol("'", "'", false);
        StringTokenizer contentTypeTokenizer = new StringTokenizer();
        contentTypeTokenizer.addSymbol(" ", true);
        contentTypeTokenizer.addSymbol(";", true);
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.ISO_8859_1);){
            jspTokenizer.setReader(reader);
            block5: while (jspTokenizer.hasMore()) {
                Token token = jspTokenizer.nextToken();
                if (!"dir".equals(token.getName())) continue;
                directiveTokenizer.setString(token.getInnerText());
                if (!directiveTokenizer.hasMore() || !"page".equals(directiveTokenizer.nextToken().getText())) continue;
                while (directiveTokenizer.hasMore()) {
                    Token directiveToken = directiveTokenizer.nextToken();
                    if ("pageEncoding".equals(directiveToken.getText())) {
                        if (!directiveTokenizer.hasMore() || !"=".equals(directiveTokenizer.nextToken().getText()) || !directiveTokenizer.hasMore()) continue;
                        encoding = directiveTokenizer.nextToken().getInnerText();
                        continue block5;
                    }
                    if (!"contentType".equals(directiveToken.getText()) || !directiveTokenizer.hasMore() || !"=".equals(directiveTokenizer.nextToken().getText()) || !directiveTokenizer.hasMore()) continue;
                    contentType = directiveTokenizer.nextToken().getInnerText();
                }
            }
        }
        if (encoding == null && contentType != null) {
            contentTypeTokenizer.setString(contentType);
            while (contentTypeTokenizer.hasMore()) {
                String token = contentTypeTokenizer.nextToken().getText();
                if (!token.startsWith("charset=")) continue;
                encoding = token.substring("charset=".length());
                break;
            }
        }
        return encoding != null ? encoding : "ISO-8859-1";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendFile(HttpServletRequest request, HttpServletResponse response, File file) throws IOException {
        try (ServletOutputStream out = response.getOutputStream();
             RandomAccessFile raf = new RandomAccessFile(file, "r");){
            long fileSize = raf.length();
            long rangeStart = 0L;
            long rangeFinish = fileSize - 1L;
            String range = request.getHeader("Range");
            if (range != null && range.startsWith("bytes=")) {
                String pureRange = range.replaceAll("bytes=", "");
                int rangeSep = pureRange.indexOf(45);
                try {
                    rangeStart = Long.parseLong(pureRange.substring(0, rangeSep));
                    if (rangeStart > fileSize || rangeStart < 0L) {
                        rangeStart = 0L;
                    }
                }
                catch (NumberFormatException e) {
                    logger.trace("", (Throwable)e);
                }
                if (rangeSep < pureRange.length() - 1) {
                    try {
                        rangeFinish = Long.parseLong(pureRange.substring(rangeSep + 1));
                        if (rangeFinish < 0L || rangeFinish >= fileSize) {
                            rangeFinish = fileSize - 1L;
                        }
                    }
                    catch (NumberFormatException e) {
                        logger.trace("", (Throwable)e);
                    }
                }
            }
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Length", Long.toString(rangeFinish - rangeStart + 1L));
            response.setHeader("Content-Range", "bytes " + rangeStart + "-" + rangeFinish + "/" + fileSize);
            raf.seek(rangeStart);
            byte[] buffer = new byte[4096];
            int totalRead = 0;
            boolean nomore = false;
            do {
                long len;
                if ((len = (long)raf.read(buffer)) > 0L && (long)totalRead + len > rangeFinish - rangeStart + 1L) {
                    len = rangeFinish - rangeStart + 1L - (long)totalRead;
                    nomore = true;
                }
                if (len <= 0L) return;
                out.write(buffer, 0, (int)len);
                totalRead = (int)((long)totalRead + len);
            } while (!nomore);
            return;
        }
    }

    public static Thread getThreadByName(String name) {
        if (name != null) {
            ThreadGroup masterGroup = Thread.currentThread().getThreadGroup();
            while (masterGroup.getParent() != null) {
                masterGroup = masterGroup.getParent();
            }
            Thread[] threads = new Thread[masterGroup.activeCount()];
            int numThreads = masterGroup.enumerate(threads);
            for (int i = 0; i < numThreads; ++i) {
                if (threads[i] == null || !name.equals(threads[i].getName())) continue;
                return threads[i];
            }
        }
        return null;
    }

    public static String highlightStream(String name, InputStream input, String rendererName, String encoding) throws IOException {
        Renderer jspRenderer = XhtmlRendererFactory.getRenderer((String)rendererName);
        if (jspRenderer == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        jspRenderer.highlight(name, input, (OutputStream)bos, encoding, true);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        Tokenizer tokenizer = new Tokenizer(new InputStreamReader((InputStream)bis, Charset.forName(encoding)));
        tokenizer.addSymbol(new TokenizerSymbol("EOL", "\n", null, false, false, true, false));
        tokenizer.addSymbol(new TokenizerSymbol("EOL", "\r\n", null, false, false, true, false));
        StringBuilder buffer = new StringBuilder();
        long counter = 0L;
        while (tokenizer.hasMore()) {
            Token tk = tokenizer.nextToken();
            if ("EOL".equals(tk.getName())) {
                ++counter;
                buffer.append(tk.getText());
                continue;
            }
            if (counter <= 0L) continue;
            buffer.append("<span class=\"codeline\">");
            buffer.append("<span class=\"linenum\">");
            buffer.append(Utils.leftPad(Long.toString(counter), 6, " ").replace(" ", "&nbsp;"));
            buffer.append("</span>");
            buffer.append(tk.getText());
            buffer.append("</span>");
        }
        return buffer.toString();
    }

    public static void sendCompressedFile(HttpServletResponse response, File file) throws IOException {
        try (ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
             BufferedInputStream fileInput = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            long len;
            String fileName = file.getName();
            response.setContentType("application/zip");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".zip");
            zip.putNextEntry(new ZipEntry(fileName));
            byte[] buffer = new byte[4096];
            while ((len = (long)((InputStream)fileInput).read(buffer)) > 0L) {
                zip.write(buffer, 0, (int)len);
            }
            zip.closeEntry();
        }
    }

    protected static String leftPad(String str, int len, String fill) {
        if (str != null && str.length() < len) {
            return Strings.padStart((String)str, (int)len, (char)fill.charAt(0));
        }
        return str == null ? "" : str;
    }

    public static List<String> getNamesForLocale(String baseName, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(baseName);
        if (language.length() > 0) {
            temp.append('_').append(language);
            result.add(0, temp.toString());
        }
        if (country.length() > 0) {
            temp.append('_').append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }

    public static boolean isThreadingEnabled() {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName threadingOName = new ObjectName("java.lang:type=Threading");
            Set<ObjectInstance> threading = mbeanServer.queryMBeans(threadingOName, null);
            return threading != null && !threading.isEmpty();
        }
        catch (MalformedObjectNameException e) {
            logger.trace("", (Throwable)e);
            return false;
        }
    }
}

