/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import psiprobe.TomcatContainer;
import psiprobe.beans.ResourceResolver;
import psiprobe.model.ApplicationResource;

public class ContainerWrapperBean {
    private static final Logger logger = LoggerFactory.getLogger(ContainerWrapperBean.class);
    private volatile TomcatContainer tomcatContainer;
    private final Object lock = new Object();
    @Inject
    private List<String> adapterClasses;
    private ResourceResolver resourceResolver;
    private boolean forceFirstAdapter;
    @Inject
    private Map<String, ResourceResolver> resourceResolvers;

    public boolean isForceFirstAdapter() {
        return this.forceFirstAdapter;
    }

    @Value(value="false")
    public void setForceFirstAdapter(boolean forceFirstAdapter) {
        this.forceFirstAdapter = forceFirstAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWrapper(Wrapper wrapper) {
        if (this.tomcatContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.tomcatContainer == null) {
                    String serverInfo = ServerInfo.getServerInfo();
                    logger.info("Server info: {}", (Object)serverInfo);
                    for (String className : this.adapterClasses) {
                        try {
                            Object obj = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            logger.debug("Testing container adapter: {}", (Object)className);
                            if (obj instanceof TomcatContainer) {
                                if (this.forceFirstAdapter || ((TomcatContainer)obj).canBoundTo(serverInfo)) {
                                    logger.info("Using {}", (Object)className);
                                    this.tomcatContainer = (TomcatContainer)obj;
                                    this.tomcatContainer.setWrapper(wrapper);
                                    break;
                                }
                                logger.debug("Cannot bind {} to {}", (Object)className, (Object)serverInfo);
                                continue;
                            }
                            logger.error("{} does not implement {}", (Object)className, (Object)TomcatContainer.class.getName());
                        }
                        catch (Exception e) {
                            logger.debug("", (Throwable)e);
                            logger.info("Failed to load {}", (Object)className);
                        }
                    }
                    if (this.tomcatContainer == null) {
                        logger.error("No suitable container adapter found!");
                    }
                }
            }
        }
        try {
            if (this.tomcatContainer != null && wrapper == null) {
                logger.info("Unregistering container adapter");
                this.tomcatContainer.setWrapper(null);
            }
        }
        catch (Exception e) {
            logger.error("Could not unregister container adapter", (Throwable)e);
        }
    }

    public TomcatContainer getTomcatContainer() {
        return this.tomcatContainer;
    }

    public List<String> getAdapterClasses() {
        return this.adapterClasses;
    }

    public void setAdapterClasses(List<String> adapterClasses) {
        this.adapterClasses = adapterClasses;
    }

    public ResourceResolver getResourceResolver() {
        if (this.resourceResolver == null) {
            if (System.getProperty("jboss.server.name") != null) {
                this.resourceResolver = this.resourceResolvers.get("jboss");
                logger.info("Using JBOSS resource resolver");
            } else {
                this.resourceResolver = this.resourceResolvers.get("default");
                logger.info("Using DEFAULT resource resolver");
            }
        }
        return this.resourceResolver;
    }

    public Map<String, ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceResolvers(Map<String, ResourceResolver> resourceResolvers) {
        this.resourceResolvers = resourceResolvers;
    }

    public List<ApplicationResource> getDataSources() throws Exception {
        ArrayList<ApplicationResource> resources = new ArrayList<ApplicationResource>();
        resources.addAll(this.getPrivateDataSources());
        resources.addAll(this.getGlobalDataSources());
        return resources;
    }

    public List<ApplicationResource> getPrivateDataSources() throws Exception {
        ArrayList<ApplicationResource> resources = new ArrayList<ApplicationResource>();
        if (this.tomcatContainer != null && this.getResourceResolver().supportsPrivateResources()) {
            for (Context app : this.getTomcatContainer().findContexts()) {
                List<ApplicationResource> appResources = this.getResourceResolver().getApplicationResources(app, this);
                this.filterDataSources(appResources, resources);
            }
        }
        return resources;
    }

    public List<ApplicationResource> getGlobalDataSources() throws Exception {
        ArrayList<ApplicationResource> resources = new ArrayList<ApplicationResource>();
        if (this.getResourceResolver().supportsGlobalResources()) {
            List<ApplicationResource> globalResources = this.getResourceResolver().getApplicationResources();
            this.filterDataSources(globalResources, resources);
        }
        return resources;
    }

    protected void filterDataSources(List<ApplicationResource> resources, List<ApplicationResource> dataSources) {
        for (ApplicationResource res : resources) {
            if (res.getDataSourceInfo() == null) continue;
            dataSources.add(res);
        }
    }
}

