/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.juli.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ClassUtils;
import psiprobe.beans.ContainerWrapperBean;
import psiprobe.model.Application;
import psiprobe.model.DisconnectedLogDestination;
import psiprobe.tools.ApplicationUtils;
import psiprobe.tools.Instruments;
import psiprobe.tools.logging.FileLogAccessor;
import psiprobe.tools.logging.LogDestination;
import psiprobe.tools.logging.catalina.CatalinaLoggerAccessor;
import psiprobe.tools.logging.commons.CommonsLoggerAccessor;
import psiprobe.tools.logging.jdk.Jdk14LoggerAccessor;
import psiprobe.tools.logging.jdk.Jdk14ManagerAccessor;
import psiprobe.tools.logging.log4j.Log4JLoggerAccessor;
import psiprobe.tools.logging.log4j.Log4JManagerAccessor;
import psiprobe.tools.logging.log4j2.Log4J2AppenderAccessor;
import psiprobe.tools.logging.log4j2.Log4J2LoggerConfigAccessor;
import psiprobe.tools.logging.log4j2.Log4J2LoggerContextAccessor;
import psiprobe.tools.logging.log4j2.Log4J2WebLoggerContextUtilsAccessor;
import psiprobe.tools.logging.logback.LogbackFactoryAccessor;
import psiprobe.tools.logging.logback.LogbackLoggerAccessor;
import psiprobe.tools.logging.slf4jlogback.TomcatSlf4jLogbackFactoryAccessor;
import psiprobe.tools.logging.slf4jlogback.TomcatSlf4jLogbackLoggerAccessor;

public class LogResolverBean {
    private static final Logger logger = LoggerFactory.getLogger(LogResolverBean.class);
    @Inject
    private ContainerWrapperBean containerWrapper;
    private List<String> stdoutFiles = new ArrayList<String>();

    public ContainerWrapperBean getContainerWrapper() {
        return this.containerWrapper;
    }

    public void setContainerWrapper(ContainerWrapperBean containerWrapper) {
        this.containerWrapper = containerWrapper;
    }

    public List<String> getStdoutFiles() {
        return this.stdoutFiles;
    }

    @Autowired
    public void setStdoutFiles(List<String> stdoutFiles) {
        logger.info("stdoutFiles {}", stdoutFiles);
        this.stdoutFiles = stdoutFiles;
    }

    public List<LogDestination> getLogDestinations(boolean all) {
        List<LogDestination> allAppenders = this.getAllLogDestinations();
        if (allAppenders == null) {
            return null;
        }
        LinkedList<LogDestination> uniqueList = new LinkedList<LogDestination>();
        LogDestinationComparator cmp = new LogDestinationComparator(all);
        Collections.sort(allAppenders, cmp);
        for (LogDestination dest : allAppenders) {
            if (Collections.binarySearch(uniqueList, dest, cmp) >= 0 || !all && dest.getFile() != null && !dest.getFile().exists()) continue;
            uniqueList.add(new DisconnectedLogDestination().builder(dest));
        }
        return uniqueList;
    }

    public List<LogDestination> getLogSources(File logFile) {
        LinkedList<LogDestination> filtered = new LinkedList<LogDestination>();
        List<LogDestination> sources = this.getLogSources();
        for (LogDestination dest : sources) {
            if (!logFile.equals(dest.getFile())) continue;
            filtered.add(dest);
        }
        return filtered;
    }

    public List<LogDestination> getLogSources() {
        LinkedList<LogDestination> sources = new LinkedList<LogDestination>();
        List<LogDestination> allAppenders = this.getAllLogDestinations();
        if (allAppenders != null) {
            LogSourceComparator cmp = new LogSourceComparator();
            Collections.sort(allAppenders, cmp);
            for (LogDestination dest : allAppenders) {
                if (Collections.binarySearch(sources, dest, cmp) >= 0) continue;
                sources.add(new DisconnectedLogDestination().builder(dest));
            }
        }
        return sources;
    }

    private List<LogDestination> getAllLogDestinations() {
        if (!Instruments.isInitialized()) {
            return null;
        }
        ArrayList<LogDestination> allAppenders = new ArrayList<LogDestination>();
        for (ClassLoader cl2 = Thread.currentThread().getContextClassLoader().getParent(); cl2 != null; cl2 = cl2.getParent()) {
            this.interrogateClassLoader(cl2, null, allAppenders);
        }
        this.interrogateStdOutFiles(allAppenders);
        List<Context> contexts = this.getContainerWrapper().getTomcatContainer().findContexts();
        for (Context ctx : contexts) {
            this.interrogateContext(ctx, allAppenders);
        }
        return allAppenders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogDestination getLogDestination(String logType, String webapp, boolean context, boolean root, String logName, String logIndex) {
        LogDestination result = null;
        Context ctx = null;
        Application application = null;
        if (webapp != null && (ctx = this.getContainerWrapper().getTomcatContainer().findContext(webapp)) != null) {
            application = ApplicationUtils.getApplication(ctx, this.getContainerWrapper());
        }
        if (logName != null && "stdout".equals(logType)) {
            result = this.getStdoutLogDestination(logName);
        } else if (ctx != null && "catalina".equals(logType)) {
            result = this.getCatalinaLogDestination(ctx, application);
        } else if (logIndex != null && ("jdk".equals(logType) || "log4j".equals(logType) || "log4j2".equals(logType) || "logback".equals(logType)) || "tomcatSlf4jLogback".equals(logType)) {
            if (context && ctx != null && !"log4j2".equals(logType)) {
                result = this.getCommonsLogDestination(ctx, application, logIndex);
            } else if (ctx != null && "log4j2".equals(logType)) {
                result = this.getLog4J2LogDestination(ctx, application, root, logName, logIndex);
            } else {
                ClassLoader cl;
                ClassLoader prevCl = null;
                if (ctx != null) {
                    cl = ctx.getLoader().getClassLoader();
                    prevCl = ClassUtils.overrideThreadContextClassLoader((ClassLoader)cl);
                } else {
                    cl = Thread.currentThread().getContextClassLoader().getParent();
                }
                try {
                    if ((root || logName != null) && logIndex != null) {
                        if ("jdk".equals(logType)) {
                            result = this.getJdk14LogDestination(cl, application, root, logName, logIndex);
                        } else if ("log4j".equals(logType)) {
                            result = this.getLog4JLogDestination(cl, application, root, logName, logIndex);
                        } else if ("logback".equals(logType)) {
                            result = this.getLogbackLogDestination(cl, application, root, logName, logIndex);
                        } else if ("tomcatSlf4jLogback".equals(logType)) {
                            result = this.getLogbackTomcatJuliLogDestination(cl, application, root, logName, logIndex);
                        }
                    }
                }
                finally {
                    if (prevCl != null) {
                        ClassUtils.overrideThreadContextClassLoader((ClassLoader)prevCl);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrogateContext(Context ctx, List<LogDestination> allAppenders) {
        Application application = ApplicationUtils.getApplication(ctx, this.getContainerWrapper());
        ClassLoader cl = ctx.getLoader().getClassLoader();
        Log contextLogger = ctx.getLogger();
        if (contextLogger != null) {
            if (contextLogger.getClass().getName().startsWith("org.apache.commons.logging")) {
                CommonsLoggerAccessor commonsAccessor = new CommonsLoggerAccessor();
                commonsAccessor.setTarget(contextLogger);
                commonsAccessor.setApplication(application);
                allAppenders.addAll(commonsAccessor.getDestinations());
            } else if (contextLogger.getClass().getName().startsWith("org.apache.catalina.logger")) {
                CatalinaLoggerAccessor catalinaAccessor = new CatalinaLoggerAccessor();
                catalinaAccessor.setApplication(application);
                catalinaAccessor.setTarget(contextLogger);
                allAppenders.add(catalinaAccessor);
            }
            ServletContext servletContext = ctx.getServletContext();
            try {
                Log4J2LoggerContextAccessor loggerContextAccessor = null;
                try {
                    Log4J2WebLoggerContextUtilsAccessor webLoggerContextUtilsAccessor = new Log4J2WebLoggerContextUtilsAccessor(cl);
                    loggerContextAccessor = webLoggerContextUtilsAccessor.getWebLoggerContext(servletContext);
                }
                catch (Exception e) {
                    logger.debug("Log4J2LoggerContextAccessor instantiation failed", (Throwable)e);
                }
                List<Object> loggerContexts = this.getLoggerContexts(cl);
                for (Object loggerContext : loggerContexts) {
                    Map<String, Object> loggerConfigs = this.getLoggerConfigs(loggerContext);
                    for (Object loggerConfig : loggerConfigs.values()) {
                        Log4J2LoggerConfigAccessor logConfigAccessor = new Log4J2LoggerConfigAccessor();
                        logConfigAccessor.setTarget(loggerConfig);
                        logConfigAccessor.setApplication(application);
                        logConfigAccessor.setContext(true);
                        logConfigAccessor.setLoggerContext(loggerContextAccessor);
                        Method getAppenders = MethodUtils.getAccessibleMethod(loggerConfig.getClass(), (String)"getAppenders", (Class[])new Class[0]);
                        Map appenders = (Map)getAppenders.invoke(loggerConfig, new Object[0]);
                        for (Object appender : appenders.values()) {
                            Log4J2AppenderAccessor appenderAccessor = new Log4J2AppenderAccessor();
                            appenderAccessor.setTarget(appender);
                            appenderAccessor.setLoggerAccessor(logConfigAccessor);
                            appenderAccessor.setApplication(application);
                            allAppenders.add(appenderAccessor);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.debug("getting appenders failed", (Throwable)e);
            }
        }
        if (application.isAvailable()) {
            ClassLoader prevCl = ClassUtils.overrideThreadContextClassLoader((ClassLoader)cl);
            try {
                this.interrogateClassLoader(cl, application, allAppenders);
            }
            catch (Exception e) {
                logger.error("Could not interrogate classloader loggers for {}. Enable debug logging to see the trace stack", (Object)ctx.getName());
                logger.debug("", (Throwable)e);
            }
            finally {
                if (prevCl != null) {
                    ClassUtils.overrideThreadContextClassLoader((ClassLoader)prevCl);
                }
            }
        }
    }

    private void interrogateClassLoader(ClassLoader cl, Application application, List<LogDestination> appenders) {
        String applicationName = application != null ? "application \"" + application.getName() + "\"" : "server";
        try {
            Jdk14ManagerAccessor jdk14accessor = new Jdk14ManagerAccessor(cl);
            jdk14accessor.setApplication(application);
            appenders.addAll(jdk14accessor.getHandlers());
        }
        catch (Exception e) {
            logger.debug("Could not resolve JDK loggers for '{}'", (Object)applicationName, (Object)e);
        }
        try {
            Log4JManagerAccessor log4JAccessor = new Log4JManagerAccessor(cl);
            log4JAccessor.setApplication(application);
            appenders.addAll(log4JAccessor.getAppenders());
        }
        catch (Exception e) {
            logger.debug("Could not resolve log4j loggers for '{}'", (Object)applicationName, (Object)e);
        }
        try {
            LogbackFactoryAccessor logbackAccessor = new LogbackFactoryAccessor(cl);
            logbackAccessor.setApplication(application);
            appenders.addAll(logbackAccessor.getAppenders());
        }
        catch (Exception e) {
            logger.debug("Could not resolve logback loggers for '{}'", (Object)applicationName, (Object)e);
        }
        try {
            TomcatSlf4jLogbackFactoryAccessor tomcatSlf4jLogbackAccessor = new TomcatSlf4jLogbackFactoryAccessor(cl);
            tomcatSlf4jLogbackAccessor.setApplication(application);
            appenders.addAll(tomcatSlf4jLogbackAccessor.getAppenders());
        }
        catch (Exception e) {
            logger.debug("Could not resolve tomcat-slf4j-logback loggers for '{}'", (Object)applicationName, (Object)e);
        }
    }

    private void interrogateStdOutFiles(List<LogDestination> appenders) {
        for (String fileName : this.stdoutFiles) {
            FileLogAccessor fla = this.resolveStdoutLogDestination(fileName);
            if (fla == null) continue;
            appenders.add(fla);
        }
    }

    private LogDestination getStdoutLogDestination(String logName) {
        for (String fileName : this.stdoutFiles) {
            FileLogAccessor fla;
            if (!fileName.equals(logName) || (fla = this.resolveStdoutLogDestination(fileName)) == null) continue;
            return fla;
        }
        return null;
    }

    private FileLogAccessor resolveStdoutLogDestination(String fileName) {
        File stdout = new File(System.getProperty("catalina.base"), "logs/" + fileName);
        if (stdout.exists()) {
            FileLogAccessor fla = new FileLogAccessor();
            fla.setName(fileName);
            fla.setFile(stdout);
            return fla;
        }
        return null;
    }

    private LogDestination getCatalinaLogDestination(Context ctx, Application application) {
        Log log = ctx.getLogger();
        if (log != null) {
            CatalinaLoggerAccessor logAccessor = new CatalinaLoggerAccessor();
            logAccessor.setTarget(log);
            logAccessor.setApplication(application);
            if (logAccessor.getFile().exists()) {
                return logAccessor;
            }
        }
        return null;
    }

    private LogDestination getCommonsLogDestination(Context ctx, Application application, String logIndex) {
        Log contextLogger = ctx.getLogger();
        CommonsLoggerAccessor commonsAccessor = new CommonsLoggerAccessor();
        commonsAccessor.setTarget(contextLogger);
        commonsAccessor.setApplication(application);
        return commonsAccessor.getDestination(logIndex);
    }

    private LogDestination getJdk14LogDestination(ClassLoader cl, Application application, boolean root, String logName, String handlerIndex) {
        try {
            Jdk14LoggerAccessor log;
            Jdk14ManagerAccessor manager = new Jdk14ManagerAccessor(cl);
            manager.setApplication(application);
            Jdk14LoggerAccessor jdk14LoggerAccessor = log = root ? manager.getRootLogger() : manager.getLogger(logName);
            if (log != null) {
                return log.getHandler(handlerIndex);
            }
        }
        catch (Exception e) {
            logger.debug("getJdk14LogDestination failed", (Throwable)e);
        }
        return null;
    }

    private LogDestination getLog4JLogDestination(ClassLoader cl, Application application, boolean root, String logName, String appenderName) {
        try {
            Log4JLoggerAccessor log;
            Log4JManagerAccessor manager = new Log4JManagerAccessor(cl);
            manager.setApplication(application);
            Log4JLoggerAccessor log4JLoggerAccessor = log = root ? manager.getRootLogger() : manager.getLogger(logName);
            if (log != null) {
                return log.getAppender(appenderName);
            }
        }
        catch (Exception e) {
            logger.debug("getLog4JLogDestination failed", (Throwable)e);
        }
        return null;
    }

    private LogDestination getLog4J2LogDestination(Context ctx, Application application, boolean root, String logName, String appenderName) {
        Log4J2AppenderAccessor result = null;
        try {
            Object loggerContext;
            Map<String, Object> loggerConfigs;
            Loader loader = ctx.getLoader();
            ClassLoader classLoader = loader.getClassLoader();
            Log4J2WebLoggerContextUtilsAccessor webLoggerContextUtilsAccessor = new Log4J2WebLoggerContextUtilsAccessor(classLoader);
            Log4J2LoggerContextAccessor loggerContextAccessor = webLoggerContextUtilsAccessor.getWebLoggerContext(ctx.getServletContext());
            List<Object> loggerContexts = this.getLoggerContexts(classLoader);
            Object loggerConfig = null;
            Iterator<Object> iterator = loggerContexts.iterator();
            while (iterator.hasNext() && (loggerConfig = (loggerConfigs = this.getLoggerConfigs(loggerContext = iterator.next())).get(root ? "" : logName)) == null) {
            }
            if (loggerConfig != null) {
                Log4J2LoggerConfigAccessor accessor = new Log4J2LoggerConfigAccessor();
                accessor.setTarget(loggerConfig);
                accessor.setApplication(application);
                accessor.setContext(true);
                accessor.setLoggerContext(loggerContextAccessor);
                result = accessor.getAppender(appenderName);
            }
        }
        catch (Exception e) {
            logger.debug("getLog4J2LogDestination failed", (Throwable)e);
        }
        logger.debug("getLog4J2LogDestination(): OUT: result={}", result);
        return result;
    }

    private Map<String, Object> getLoggerConfigs(Object loggerContext) throws IllegalAccessException, InvocationTargetException {
        Method getConfiguration = MethodUtils.getAccessibleMethod(loggerContext.getClass(), (String)"getConfiguration", (Class[])new Class[0]);
        Object configuration = getConfiguration.invoke(loggerContext, new Object[0]);
        Method getLoggerConfigs = MethodUtils.getAccessibleMethod(configuration.getClass(), (String)"getLoggers", (Class[])new Class[0]);
        return (Map)getLoggerConfigs.invoke(configuration, new Object[0]);
    }

    private List<Object> getLoggerContexts(ClassLoader cl) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, NoSuchMethodException, SecurityException {
        Class<?> clazz = cl.loadClass("org.apache.logging.log4j.core.selector.ClassLoaderContextSelector");
        Object classLoaderContextSelector = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method getLoggerContexts = MethodUtils.getAccessibleMethod(clazz, (String)"getLoggerContexts", (Class[])new Class[0]);
        return (List)getLoggerContexts.invoke(classLoaderContextSelector, new Object[0]);
    }

    private LogDestination getLogbackLogDestination(ClassLoader cl, Application application, boolean root, String logName, String appenderName) {
        try {
            LogbackLoggerAccessor log;
            LogbackFactoryAccessor manager = new LogbackFactoryAccessor(cl);
            manager.setApplication(application);
            LogbackLoggerAccessor logbackLoggerAccessor = log = root ? manager.getRootLogger() : manager.getLogger(logName);
            if (log != null) {
                return log.getAppender(appenderName);
            }
        }
        catch (Exception e) {
            logger.debug("getLogbackLogDestination failed", (Throwable)e);
        }
        return null;
    }

    private LogDestination getLogbackTomcatJuliLogDestination(ClassLoader cl, Application application, boolean root, String logName, String appenderName) {
        try {
            TomcatSlf4jLogbackLoggerAccessor log;
            TomcatSlf4jLogbackFactoryAccessor manager = new TomcatSlf4jLogbackFactoryAccessor(cl);
            manager.setApplication(application);
            TomcatSlf4jLogbackLoggerAccessor tomcatSlf4jLogbackLoggerAccessor = log = root ? manager.getRootLogger() : manager.getLogger(logName);
            if (log != null) {
                return log.getAppender(appenderName);
            }
        }
        catch (Exception e) {
            logger.debug("getTomcatSlf4jLogbackLogDestination failed", (Throwable)e);
        }
        return null;
    }

    private static class LogSourceComparator
    extends AbstractLogComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private LogSourceComparator() {
        }

        @Override
        protected String convertToString(LogDestination dest) {
            File file = dest.getFile();
            String fileName = file == null ? "" : file.getAbsolutePath();
            Application app = dest.getApplication();
            String appName = app == null ? Character.toString('!') : app.getName();
            String logType = dest.getLogType();
            String context = dest.isContext() ? "is" : "not";
            String root = dest.isRoot() ? "is" : "not";
            String logName = dest.getName();
            return appName + '!' + logType + '!' + context + '!' + root + '!' + logName + '!' + fileName;
        }
    }

    private static class LogDestinationComparator
    extends AbstractLogComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean all;

        public LogDestinationComparator(boolean all) {
            this.all = all;
        }

        @Override
        protected String convertToString(LogDestination dest) {
            String name;
            String fileName;
            File file = dest.getFile();
            String string = fileName = file == null ? "" : file.getAbsolutePath();
            if (this.all) {
                Application app = dest.getApplication();
                String appName = app == null ? Character.toString('!') : app.getName();
                String context = dest.isContext() ? "is" : "not";
                String root = dest.isRoot() ? "is" : "not";
                String logType = dest.getLogType();
                name = appName + '!' + context + '!' + root + '!' + logType + '!' + fileName;
            } else {
                name = fileName;
            }
            return name;
        }
    }

    private static abstract class AbstractLogComparator
    implements Comparator<LogDestination>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final char DELIM = '!';

        private AbstractLogComparator() {
        }

        @Override
        public final int compare(LogDestination o1, LogDestination o2) {
            String name1 = this.convertToString(o1);
            String name2 = this.convertToString(o2);
            return name1.compareTo(name2);
        }

        protected abstract String convertToString(LogDestination var1);
    }
}

