/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.accessors;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.lang.management.ManagementFactory;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import psiprobe.beans.accessors.DatasourceAccessor;
import psiprobe.model.DataSourceInfo;

public class HikariCpDatasourceAccessor
implements DatasourceAccessor {
    public DataSourceInfo getInfo(Object resource) throws Exception {
        DataSourceInfo dataSourceInfo = null;
        if (this.canMap(resource)) {
            HikariDataSource source = (HikariDataSource)resource;
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + source.getPoolName() + ")");
            HikariPoolMXBean poolProxy = JMX.newMXBeanProxy(mbeanServer, poolName, HikariPoolMXBean.class);
            dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.setBusyConnections(poolProxy.getActiveConnections());
            dataSourceInfo.setEstablishedConnections(poolProxy.getTotalConnections());
            dataSourceInfo.setMaxConnections(source.getMaximumPoolSize());
            dataSourceInfo.setJdbcUrl(source.getJdbcUrl());
            dataSourceInfo.setUsername(source.getUsername());
            dataSourceInfo.setResettable(false);
            dataSourceInfo.setType("hikari");
        }
        return dataSourceInfo;
    }

    public boolean reset(Object resource) throws Exception {
        return false;
    }

    public boolean canMap(Object resource) {
        return "com.zaxxer.hikari.HikariDataSource".equals(resource.getClass().getName()) && resource instanceof HikariDataSource;
    }
}

