/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.accessors;

import org.apache.openejb.resource.jdbc.managed.local.ManagedDataSource;
import org.apache.tomcat.jdbc.pool.DataSourceProxy;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import psiprobe.beans.accessors.DatasourceAccessor;
import psiprobe.model.DataSourceInfo;

public class OpenEjbManagedDatasourceAccessor
implements DatasourceAccessor {
    public DataSourceInfo getInfo(Object resource) throws Exception {
        DataSourceInfo dataSourceInfo = null;
        if (this.canMap(resource)) {
            PoolConfiguration conf = (PoolConfiguration)this.unwrap(resource);
            DataSourceProxy proxy = (DataSourceProxy)conf;
            dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.setBusyConnections(proxy.getNumActive());
            dataSourceInfo.setEstablishedConnections(proxy.getNumIdle() + proxy.getNumActive());
            dataSourceInfo.setMaxConnections(conf.getMaxActive());
            dataSourceInfo.setJdbcUrl(conf.getUrl());
            dataSourceInfo.setUsername(conf.getUsername());
            dataSourceInfo.setResettable(false);
            dataSourceInfo.setType("tomee-jdbc");
        }
        return dataSourceInfo;
    }

    public boolean reset(Object resource) throws Exception {
        return false;
    }

    public boolean canMap(Object resource) {
        if ("org.apache.openejb.resource.jdbc.managed.local.ManagedDataSource".equals(resource.getClass().getName())) {
            Object wrapped = this.unwrap(resource);
            return wrapped instanceof DataSourceProxy && wrapped instanceof PoolConfiguration;
        }
        return false;
    }

    private Object unwrap(Object resource) {
        return ((ManagedDataSource)resource).getDelegate();
    }
}

