/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.accessors;

import org.apache.tomcat.jdbc.pool.DataSource;
import psiprobe.beans.accessors.DatasourceAccessor;
import psiprobe.model.DataSourceInfo;

public class TomcatJdbcPoolDatasourceAccessor
implements DatasourceAccessor {
    public DataSourceInfo getInfo(Object resource) throws Exception {
        DataSourceInfo dataSourceInfo = null;
        if (this.canMap(resource)) {
            DataSource source = (DataSource)resource;
            dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.setBusyConnections(source.getNumActive());
            dataSourceInfo.setEstablishedConnections(source.getNumIdle() + source.getNumActive());
            dataSourceInfo.setMaxConnections(source.getMaxActive());
            dataSourceInfo.setJdbcUrl(source.getUrl());
            dataSourceInfo.setUsername(source.getUsername());
            dataSourceInfo.setResettable(false);
            dataSourceInfo.setType("tomcat-jdbc");
        }
        return dataSourceInfo;
    }

    public boolean reset(Object resource) throws Exception {
        return false;
    }

    public boolean canMap(Object resource) {
        return "org.apache.tomcat.jdbc.pool.DataSource".equals(resource.getClass().getName()) && resource instanceof DataSource;
    }
}

