/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.listeners;

import java.util.HashMap;
import java.util.LinkedList;
import psiprobe.Utils;
import psiprobe.beans.stats.listeners.AbstractThresholdListener;
import psiprobe.beans.stats.listeners.StatsCollectionEvent;

public abstract class AbstractFlapListener
extends AbstractThresholdListener {
    private int defaultFlapInterval;
    private float defaultFlapStartThreshold;
    private float defaultFlapStopThreshold;
    private float defaultFlapLowWeight;
    private float defaultFlapHighWeight;
    private final HashMap<String, LinkedList<Boolean>> flaps = new HashMap();
    private final HashMap<String, Boolean> flappingStates = new HashMap();

    protected abstract void flappingStarted(StatsCollectionEvent var1);

    protected abstract void aboveThresholdFlappingStopped(StatsCollectionEvent var1);

    protected abstract void belowThresholdFlappingStopped(StatsCollectionEvent var1);

    protected abstract void aboveThresholdNotFlapping(StatsCollectionEvent var1);

    protected abstract void belowThresholdNotFlapping(StatsCollectionEvent var1);

    @Override
    protected void crossedAboveThreshold(StatsCollectionEvent sce) {
        this.statsCollected(sce, true, true);
    }

    @Override
    protected void crossedBelowThreshold(StatsCollectionEvent sce) {
        this.statsCollected(sce, true, false);
    }

    @Override
    protected void remainedAboveThreshold(StatsCollectionEvent sce) {
        this.statsCollected(sce, false, true);
    }

    @Override
    protected void remainedBelowThreshold(StatsCollectionEvent sce) {
        this.statsCollected(sce, false, false);
    }

    @Override
    public void reset() {
        this.flaps.clear();
        this.flappingStates.clear();
        super.reset();
    }

    protected void statsCollected(StatsCollectionEvent sce, boolean crossedThreshold, boolean above) {
        String name = sce.getName();
        boolean flappingStateChanged = this.checkFlappingStateChanged(name, crossedThreshold);
        boolean flappingState = this.getFlappingState(name);
        if (flappingStateChanged) {
            if (flappingState) {
                this.flappingStarted(sce);
            } else if (above) {
                this.aboveThresholdFlappingStopped(sce);
            } else {
                this.belowThresholdFlappingStopped(sce);
            }
        } else if (crossedThreshold) {
            if (above) {
                this.aboveThresholdNotFlapping(sce);
            } else {
                this.belowThresholdNotFlapping(sce);
            }
        }
    }

    protected boolean checkFlappingStateChanged(String name, boolean crossedThreshold) {
        this.addFlap(name, crossedThreshold);
        boolean oldFlappingState = this.getFlappingState(name);
        float transitionPercent = this.calculateStateTransitionPercentage(name, oldFlappingState);
        boolean newFlappingState = oldFlappingState ? transitionPercent <= this.getFlapStopThreshold(name) : transitionPercent > this.getFlapStartThreshold(name);
        this.setFlappingState(name, newFlappingState);
        return oldFlappingState != newFlappingState;
    }

    protected float calculateStateTransitionPercentage(String name, boolean flapping) {
        int flapInterval = this.getFlapInterval(name);
        LinkedList<Boolean> list = this.getFlaps(name);
        float lowWeight = this.getFlapLowWeight(name);
        float highWeight = this.getFlapHighWeight(name);
        float weightRange = highWeight - lowWeight;
        float result = 0.0f;
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean thisFlap = list.get(i);
            if (flapping == thisFlap) continue;
            float weight = lowWeight + weightRange * (float)i / (float)(flapInterval - 1);
            result += weight;
        }
        return result / (float)flapInterval;
    }

    protected void addFlap(String name, boolean flap) {
        int flapInterval = this.getFlapInterval(name);
        LinkedList<Boolean> list = this.getFlaps(name);
        Boolean value = flap;
        list.addLast(value);
        while (list.size() > flapInterval) {
            list.removeFirst();
        }
    }

    protected boolean getFlappingState(String name) {
        Boolean flapping = this.flappingStates.get(name);
        if (flapping == null) {
            flapping = Boolean.FALSE;
            this.setFlappingState(name, false);
        }
        return flapping;
    }

    protected void setFlappingState(String name, boolean flapping) {
        this.flappingStates.put(name, flapping);
    }

    protected LinkedList<Boolean> getFlaps(String name) {
        LinkedList<Boolean> list = this.flaps.get(name);
        if (list == null) {
            list = new LinkedList();
            this.flaps.put(name, list);
        }
        return list;
    }

    protected int getFlapInterval(String name) {
        String interval = this.getPropertyValue(name, "flapInterval");
        return Utils.toInt(interval, this.getDefaultFlapInterval());
    }

    protected float getFlapStartThreshold(String name) {
        String startThreshold = this.getPropertyValue(name, "flapStartThreshold");
        return Utils.toFloat(startThreshold, this.getDefaultFlapStartThreshold());
    }

    protected float getFlapStopThreshold(String name) {
        String stopThreshold = this.getPropertyValue(name, "flapStopThreshold");
        return Utils.toFloat(stopThreshold, this.getDefaultFlapStopThreshold());
    }

    protected float getFlapLowWeight(String name) {
        String lowWeight = this.getPropertyValue(name, "flapLowWeight");
        return Utils.toFloat(lowWeight, this.getDefaultFlapLowWeight());
    }

    protected float getFlapHighWeight(String name) {
        String highWeight = this.getPropertyValue(name, "flapHighWeight");
        return Utils.toFloat(highWeight, this.getDefaultFlapHighWeight());
    }

    public int getDefaultFlapInterval() {
        return this.defaultFlapInterval;
    }

    public void setDefaultFlapInterval(int defaultFlapInterval) {
        this.defaultFlapInterval = defaultFlapInterval;
    }

    public float getDefaultFlapStartThreshold() {
        return this.defaultFlapStartThreshold;
    }

    public void setDefaultFlapStartThreshold(float defaultFlapStartThreshold) {
        this.defaultFlapStartThreshold = defaultFlapStartThreshold;
    }

    public float getDefaultFlapStopThreshold() {
        return this.defaultFlapStopThreshold;
    }

    public void setDefaultFlapStopThreshold(float defaultFlapStopThreshold) {
        this.defaultFlapStopThreshold = defaultFlapStopThreshold;
    }

    public float getDefaultFlapLowWeight() {
        return this.defaultFlapLowWeight;
    }

    public void setDefaultFlapLowWeight(float defaultFlapLowWeight) {
        this.defaultFlapLowWeight = defaultFlapLowWeight;
    }

    public float getDefaultFlapHighWeight() {
        return this.defaultFlapHighWeight;
    }

    public void setDefaultFlapHighWeight(float defaultFlapHighWeight) {
        this.defaultFlapHighWeight = defaultFlapHighWeight;
    }
}

