/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.listeners;

import javax.inject.Inject;
import javax.mail.MessagingException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import psiprobe.beans.stats.listeners.AbstractFlapListener;
import psiprobe.beans.stats.listeners.StatsCollectionEvent;
import psiprobe.tools.MailMessage;
import psiprobe.tools.Mailer;

public class MemoryPoolMailingListener
extends AbstractFlapListener
implements MessageSourceAware,
InitializingBean {
    private static final String BASE_PROPERTY = "probe.src.stats.listener.memory.pool.";
    private MessageSourceAccessor messageSourceAccessor;
    @Inject
    private Mailer mailer;

    public MessageSourceAccessor getMessageSourceAccessor() {
        return this.messageSourceAccessor;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource);
    }

    public Mailer getMailer() {
        return this.mailer;
    }

    public void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getMailer().getSmtp() == null) {
            this.logger.info("Mailer SMTP host is not set.  Disabling listener.");
            this.setEnabled(false);
        } else if (this.getMailer().getDefaultTo() == null) {
            this.logger.info("Mailer default recipient is not set.  Disabling listener.");
            this.setEnabled(false);
        }
    }

    @Override
    protected void flappingStarted(StatsCollectionEvent sce) {
        this.sendMail(sce, "flappingStart", false);
    }

    @Override
    protected void aboveThresholdFlappingStopped(StatsCollectionEvent sce) {
        this.sendMail(sce, "aboveThreshold", true);
    }

    @Override
    protected void belowThresholdFlappingStopped(StatsCollectionEvent sce) {
        this.sendMail(sce, "belowThreshold", true);
    }

    @Override
    protected void aboveThresholdNotFlapping(StatsCollectionEvent sce) {
        this.sendMail(sce, "aboveThreshold", false);
    }

    @Override
    protected void belowThresholdNotFlapping(StatsCollectionEvent sce) {
        this.sendMail(sce, "belowThreshold", false);
    }

    protected void sendMail(StatsCollectionEvent sce, String message, boolean flappingStop) {
        String name = sce.getName();
        if (this.isSeriesDisabled(name)) {
            return;
        }
        long value = sce.getValue();
        long threshold = this.getThreshold(name);
        String subjectInfix = "";
        String bodyPrefix = "";
        if (flappingStop) {
            subjectInfix = this.getMessageSourceAccessor().getMessage("probe.src.stats.listener.memory.pool.flappingStop.subject.infix");
            bodyPrefix = this.getMessageSourceAccessor().getMessage("probe.src.stats.listener.memory.pool.flappingStop.body.prefix");
        }
        String subject = this.getMessageSourceAccessor().getMessage(BASE_PROPERTY + message + ".subject", new Object[]{subjectInfix, name, value, threshold});
        String body = this.getMessageSourceAccessor().getMessage(BASE_PROPERTY + message + ".body", new Object[]{bodyPrefix, name, value, threshold});
        MailMessage mail = new MailMessage(null, subject, body);
        try {
            this.getMailer().send(mail);
        }
        catch (MessagingException ex) {
            this.logger.error("Cannot send message", (Throwable)ex);
        }
    }

    @Override
    @Value(value="${psiprobe.beans.stats.listeners.flapInterval}")
    public void setDefaultFlapInterval(int defaultFlapInterval) {
        super.setDefaultFlapInterval(defaultFlapInterval);
    }

    @Override
    @Value(value="${psiprobe.beans.stats.listeners.flapStartThreshold}")
    public void setDefaultFlapStartThreshold(float defaultFlapStartThreshold) {
        super.setDefaultFlapStartThreshold(defaultFlapStartThreshold);
    }

    @Override
    @Value(value="${psiprobe.beans.stats.listeners.flapStopThreshold}")
    public void setDefaultFlapStopThreshold(float defaultFlapStopThreshold) {
        super.setDefaultFlapStopThreshold(defaultFlapStopThreshold);
    }

    @Override
    @Value(value="${psiprobe.beans.stats.listeners.flapLowWeight}")
    public void setDefaultFlapLowWeight(float defaultFlapLowWeight) {
        super.setDefaultFlapLowWeight(defaultFlapLowWeight);
    }

    @Override
    @Value(value="${psiprobe.beans.stats.listeners.flapHighWeight}")
    public void setDefaultFlapHighWeight(float defaultFlapHighWeight) {
        super.setDefaultFlapHighWeight(defaultFlapHighWeight);
    }
}

