/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataItem;
import psiprobe.beans.stats.providers.AbstractSeriesProvider;
import psiprobe.model.stats.StatsCollection;

public class MultipleSeriesProvider
extends AbstractSeriesProvider {
    private String statNamePrefix;
    private int top;
    private int movingAvgFrame;

    public String getStatNamePrefix() {
        return this.statNamePrefix;
    }

    public void setStatNamePrefix(String statNamePrefix) {
        this.statNamePrefix = statNamePrefix;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getMovingAvgFrame() {
        return this.movingAvgFrame;
    }

    public void setMovingAvgFrame(int movingAvgFrame) {
        this.movingAvgFrame = movingAvgFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populate(DefaultTableXYDataset dataset, StatsCollection statsCollection, HttpServletRequest request) {
        Map<String, List<XYDataItem>> statMap = statsCollection.getStatsByPrefix(this.statNamePrefix);
        boolean useTop = this.getTop() > 0 && this.getTop() < statMap.size();
        ArrayList<Series> seriesList = new ArrayList<Series>(statMap.size());
        for (Map.Entry<String, List<XYDataItem>> entry : statMap.entrySet()) {
            Series ser = new Series(entry);
            if (useTop) {
                ser.calculateAvg();
            }
            seriesList.add(ser);
        }
        if (useTop) {
            Collections.sort(seriesList, new Comparator<Series>(){

                @Override
                public int compare(Series s1, Series s2) {
                    return Double.compare(s1.avg, s2.avg) == 0 ? s1.key.compareTo(s2.key) : (Double.compare(s1.avg, s2.avg) > 0 ? -1 : 1);
                }
            });
            ListIterator i = seriesList.listIterator(this.getTop());
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }
        Collections.sort(seriesList, new Comparator<Series>(){

            @Override
            public int compare(Series s1, Series s2) {
                return s1.key.compareTo(s2.key);
            }
        });
        for (Series ser : seriesList) {
            List<XYDataItem> list = ser.stats;
            synchronized (list) {
                dataset.addSeries(this.toSeries(ser.key, ser.stats));
            }
        }
    }

    private class Series {
        final String key;
        final List<XYDataItem> stats;
        double avg = 0.0;

        Series(Map.Entry<String, List<XYDataItem>> en) {
            this.key = en.getKey().substring(MultipleSeriesProvider.this.statNamePrefix.length());
            this.stats = en.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void calculateAvg() {
            long sum = 0L;
            int count = 1;
            List<XYDataItem> list = this.stats;
            synchronized (list) {
                boolean useMovingAvg = MultipleSeriesProvider.this.getMovingAvgFrame() > 0 && MultipleSeriesProvider.this.getMovingAvgFrame() < this.stats.size();
                ListIterator<XYDataItem> it = this.stats.listIterator();
                while (it.hasNext()) {
                    XYDataItem xy = it.next();
                    sum += xy.getY().longValue();
                    if (useMovingAvg && count % MultipleSeriesProvider.this.getMovingAvgFrame() == 0 || !it.hasNext()) {
                        double thisAvg = (double)sum / (double)count;
                        if (thisAvg > this.avg) {
                            this.avg = thisAvg;
                        }
                        sum = 0L;
                        count = 1;
                        continue;
                    }
                    ++count;
                }
            }
        }
    }
}

