/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers;

import com.thoughtworks.xstream.XStream;
import java.io.Writer;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import psiprobe.model.TransportableModel;

@Controller
public class BeanToXmlController
extends AbstractController {
    private String xmlMarker;
    @Inject
    private XStream xstream;

    public String getXmlMarker() {
        return this.xmlMarker;
    }

    @Value(value=".oxml")
    public void setXmlMarker(String xmlMarker) {
        this.xmlMarker = xmlMarker;
    }

    @RequestMapping(path={"/*.oxml.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView;
        String path = request.getServletPath();
        String internalPath = path.replaceAll(this.xmlMarker, "");
        org.springframework.web.servlet.mvc.Controller controller = (org.springframework.web.servlet.mvc.Controller)this.getApplicationContext().getBean(internalPath);
        if (controller != null && (modelAndView = controller.handleRequest(request, response)).getModel() != null) {
            TransportableModel tm = new TransportableModel();
            tm.putAll(modelAndView.getModel());
            this.xstream.toXML((Object)tm, (Writer)response.getWriter());
        }
        return null;
    }
}

