/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.apps;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.Utils;
import psiprobe.controllers.AbstractContextHandlerController;

public class BaseDownloadXmlConfController
extends AbstractContextHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(BaseDownloadXmlConfController.class);
    private static final String TARGET_WEB_XML = "web.xml";
    private static final String TARGET_CONTEXT_XML = "context.xml";
    private String downloadTarget;

    public String getDownloadTarget() {
        return this.downloadTarget;
    }

    public void setDownloadTarget(String downloadTarget) {
        this.downloadTarget = downloadTarget;
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String xmlPath;
        if (this.downloadTarget == null) {
            throw new RuntimeException("Download target is not set for " + ((Object)((Object)this)).getClass().getName());
        }
        if (TARGET_WEB_XML.equals(this.downloadTarget)) {
            ServletContext sctx = context.getServletContext();
            xmlPath = sctx.getRealPath("/WEB-INF/web.xml");
        } else if (TARGET_CONTEXT_XML.equals(this.downloadTarget)) {
            xmlPath = this.getContainerWrapper().getTomcatContainer().getConfigFile(context).getPath();
        } else {
            throw new RuntimeException("Unknown download target " + this.getDownloadTarget());
        }
        if (xmlPath != null) {
            File xmlFile = new File(xmlPath);
            if (xmlFile.exists()) {
                Utils.sendFile(request, response, xmlFile);
            } else {
                logger.debug("File {} of {} application does not exists.", (Object)xmlPath, (Object)contextName);
            }
        } else {
            logger.debug("Cannot determine path to {} file of {} application.", (Object)this.getDownloadTarget(), (Object)contextName);
        }
        return null;
    }
}

