/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.apps;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.Utils;
import psiprobe.controllers.AbstractContextHandlerController;

public class BaseViewXmlConfController
extends AbstractContextHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(BaseViewXmlConfController.class);
    private static final String TARGET_WEB_XML = "web.xml";
    private static final String TARGET_CONTEXT_XML = "context.xml";
    private String displayTarget;
    private String downloadUrl;

    public String getDisplayTarget() {
        return this.displayTarget;
    }

    public void setDisplayTarget(String displayTarget) {
        this.displayTarget = displayTarget;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String xmlPath;
        if (this.displayTarget == null) {
            throw new RuntimeException("Display target is not set for " + ((Object)((Object)this)).getClass().getName());
        }
        File xmlFile = null;
        ModelAndView mv = new ModelAndView(this.getViewName());
        if (TARGET_WEB_XML.equals(this.displayTarget)) {
            ServletContext sctx = context.getServletContext();
            xmlPath = sctx.getRealPath("/WEB-INF/web.xml");
            xmlFile = new File(xmlPath);
            mv.addObject("fileDesc", (Object)this.getMessageSourceAccessor().getMessage("probe.src.app.viewxmlconf.webxml.desc"));
        } else if (TARGET_CONTEXT_XML.equals(this.displayTarget)) {
            xmlFile = this.getContainerWrapper().getTomcatContainer().getConfigFile(context);
            xmlPath = xmlFile != null ? xmlFile.getPath() : null;
            mv.addObject("fileDesc", (Object)this.getMessageSourceAccessor().getMessage("probe.src.app.viewxmlconf.contextxml.desc"));
        } else {
            throw new RuntimeException("Unknown display target " + this.getDisplayTarget());
        }
        mv.addObject("displayTarget", (Object)this.displayTarget);
        mv.addObject("downloadUrl", (Object)this.downloadUrl);
        if (xmlFile != null) {
            mv.addObject("fileName", (Object)xmlFile.getName());
            if (xmlFile.exists()) {
                try (InputStream fis = Files.newInputStream(xmlFile.toPath(), new OpenOption[0]);){
                    String encoding = System.getProperty("file.encoding");
                    mv.addObject("content", (Object)Utils.highlightStream(TARGET_WEB_XML, fis, "xml", encoding == null ? "ISO-8859-1" : encoding));
                }
            } else {
                logger.debug("File {} of {} application does not exists.", (Object)xmlPath, (Object)contextName);
            }
        } else {
            logger.debug("Cannot determine path to {} file of {} application.", (Object)this.getDisplayTarget(), (Object)contextName);
        }
        return mv;
    }
}

