/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.certificates;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import psiprobe.model.certificates.CertificateInfo;
import psiprobe.model.certificates.ConnectorInfo;
import psiprobe.model.certificates.SslHostConfigInfo;

public class SslHostConfigHelper {
    public SslHostConfigHelper(AbstractHttp11JsseProtocol<?> protocol, ConnectorInfo info) throws IllegalAccessException, InvocationTargetException {
        SSLHostConfig[] sslHostConfigs = protocol.findSslHostConfigs();
        ArrayList<SslHostConfigInfo> sslHostConfigInfos = new ArrayList<SslHostConfigInfo>(sslHostConfigs.length);
        info.setSslHostConfigInfos(sslHostConfigInfos);
        for (SSLHostConfig sslHostConfig : sslHostConfigs) {
            sslHostConfigInfos.add(this.toSslHostConfigInfo(sslHostConfig));
        }
    }

    private SslHostConfigInfo toSslHostConfigInfo(SSLHostConfig sslHostConfig) throws IllegalAccessException, InvocationTargetException {
        SslHostConfigInfo sslHostConfigInfo = new SslHostConfigInfo();
        BeanUtils.copyProperties((Object)sslHostConfigInfo, (Object)sslHostConfig);
        Set certificates = sslHostConfig.getCertificates();
        ArrayList<CertificateInfo> certificateInfos = new ArrayList<CertificateInfo>(certificates.size());
        sslHostConfigInfo.setCertificateInfos(certificateInfos);
        for (SSLHostConfigCertificate sslHostConfigCertificate : certificates) {
            certificateInfos.add(this.toCertificateInfo(sslHostConfigCertificate));
        }
        return sslHostConfigInfo;
    }

    private CertificateInfo toCertificateInfo(SSLHostConfigCertificate sslHostConfigCertificate) throws IllegalAccessException, InvocationTargetException {
        CertificateInfo certificateInfo = new CertificateInfo();
        BeanUtils.copyProperties((Object)certificateInfo, (Object)sslHostConfigCertificate);
        return certificateInfo;
    }
}

