/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.datasources;

import javax.naming.NamingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import psiprobe.controllers.AbstractContextHandlerController;

@Controller
public class ResetDataSourceController
extends AbstractContextHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(ResetDataSourceController.class);
    private String replacePattern;

    public String getReplacePattern() {
        return this.replacePattern;
    }

    @Value(value="^http(s)?://[a-zA-Z\\-\\.0-9]+(:[0-9]+)?")
    public void setReplacePattern(String replacePattern) {
        this.replacePattern = replacePattern;
    }

    @RequestMapping(path={"/app/resetds.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String resourceName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"resource", null);
        String referer = request.getHeader("Referer");
        String redirectUrl = referer != null ? referer.replaceAll(this.replacePattern, "") : request.getContextPath() + this.getViewName();
        if (resourceName != null && resourceName.length() > 0) {
            boolean reset = false;
            try {
                reset = this.getContainerWrapper().getResourceResolver().resetResource(context, resourceName, this.getContainerWrapper());
            }
            catch (NamingException e) {
                request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.reset.datasource.notfound", new Object[]{resourceName}));
                logger.trace("", (Throwable)e);
            }
            if (!reset) {
                request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.reset.datasource.c3p0"));
            }
        }
        logger.debug("Redirected to {}", (Object)redirectUrl);
        return new ModelAndView((View)new RedirectView(redirectUrl));
    }

    @Override
    protected boolean isContextOptional() {
        return !this.getContainerWrapper().getResourceResolver().supportsPrivateResources();
    }

    @Override
    @Value(value="/resources.htm")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

