/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.deploy;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileUploadBase;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.apache.tomcat.util.http.fileupload.servlet.ServletRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;
import psiprobe.controllers.AbstractTomcatContainerController;

@Controller
public class CopySingleFileController
extends AbstractTomcatContainerController {
    private static final Logger logger = LoggerFactory.getLogger(CopySingleFileController.class);

    @RequestMapping(path={"/adm/deployfile.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<Context> apps;
        try {
            apps = this.getContainerWrapper().getTomcatContainer().findContexts();
        }
        catch (NullPointerException ex) {
            throw new IllegalStateException("No container found for your server: " + this.getServletContext().getServerInfo(), ex);
        }
        ArrayList applications = new ArrayList();
        for (Context appContext : apps) {
            if (Strings.isNullOrEmpty((String)appContext.getName())) continue;
            HashMap<String, String> app = new HashMap<String, String>();
            app.put("value", appContext.getName());
            app.put("label", appContext.getName());
            applications.add(app);
        }
        request.setAttribute("apps", applications);
        if (FileUploadBase.isMultipartContent((RequestContext)new ServletRequestContext(request))) {
            File tmpFile = null;
            String contextName = null;
            String where = null;
            boolean reload = false;
            boolean discard = false;
            DiskFileItemFactory factory = new DiskFileItemFactory(1048000, new File(System.getProperty("java.io.tmpdir")));
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(-1L);
            upload.setHeaderEncoding(StandardCharsets.UTF_8.name());
            try {
                List fileItems = upload.parseRequest((RequestContext)new ServletRequestContext(request));
                for (FileItem fi : fileItems) {
                    if (!fi.isFormField()) {
                        if (fi.getName() == null || fi.getName().length() <= 0) continue;
                        tmpFile = new File(System.getProperty("java.io.tmpdir"), FilenameUtils.getName((String)fi.getName()));
                        fi.write(tmpFile);
                        continue;
                    }
                    if ("context".equals(fi.getFieldName())) {
                        contextName = fi.getString();
                        continue;
                    }
                    if ("where".equals(fi.getFieldName())) {
                        where = fi.getString();
                        continue;
                    }
                    if ("reload".equals(fi.getFieldName()) && "yes".equals(fi.getString())) {
                        reload = true;
                        continue;
                    }
                    if (!"discard".equals(fi.getFieldName()) || !"yes".equals(fi.getString())) continue;
                    discard = true;
                }
            }
            catch (Exception e) {
                logger.error("Could not process file upload", (Throwable)e);
                request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.deploy.file.uploadfailure", new Object[]{e.getMessage()}));
                if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                    logger.error("Unable to delete temp upload file");
                }
                tmpFile = null;
            }
            String errMsg = null;
            if (tmpFile != null) {
                block31: {
                    try {
                        if (!Strings.isNullOrEmpty((String)tmpFile.getName())) {
                            contextName = this.getContainerWrapper().getTomcatContainer().formatContextName(contextName);
                            String visibleContextName = "".equals(contextName) ? "/" : contextName;
                            request.setAttribute("contextName", (Object)visibleContextName);
                            if (this.getContainerWrapper().getTomcatContainer().findContext(contextName) != null) {
                                File destFile = new File(this.getContainerWrapper().getTomcatContainer().getAppBase(), contextName + where);
                                if (destFile.exists()) {
                                    if (!destFile.getAbsolutePath().contains("..")) {
                                        FileUtils.copyFileToDirectory((File)tmpFile, (File)destFile);
                                        request.setAttribute("successFile", (Object)Boolean.TRUE);
                                        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                                        String name = auth.getName();
                                        logger.info(this.getMessageSourceAccessor().getMessage("probe.src.log.copyfile"), (Object)name, (Object)contextName);
                                        Context context = this.getContainerWrapper().getTomcatContainer().findContext(contextName);
                                        if (discard) {
                                            this.getContainerWrapper().getTomcatContainer().discardWorkDir(context);
                                            logger.info(this.getMessageSourceAccessor().getMessage("probe.src.log.discardwork"), (Object)name, (Object)contextName);
                                        }
                                        if (reload && context != null) {
                                            context.reload();
                                            request.setAttribute("reloadContext", (Object)Boolean.TRUE);
                                            logger.info(this.getMessageSourceAccessor().getMessage("probe.src.log.reload"), (Object)name, (Object)contextName);
                                        }
                                    } else {
                                        errMsg = this.getMessageSourceAccessor().getMessage("probe.src.deploy.file.pathNotValid");
                                    }
                                } else {
                                    errMsg = this.getMessageSourceAccessor().getMessage("probe.src.deploy.file.notPath");
                                }
                            } else {
                                errMsg = this.getMessageSourceAccessor().getMessage("probe.src.deploy.file.notExists", new Object[]{visibleContextName});
                            }
                        } else {
                            errMsg = this.getMessageSourceAccessor().getMessage("probe.src.deploy.file.notFile.failure");
                        }
                        if (errMsg == null) break block31;
                    }
                    catch (IOException e) {
                        block32: {
                            try {
                                errMsg = this.getMessageSourceAccessor().getMessage("probe.src.deploy.file.failure", new Object[]{e.getMessage()});
                                logger.error("Tomcat throw an exception when trying to deploy", (Throwable)e);
                                if (errMsg == null) break block32;
                            }
                            catch (Throwable throwable) {
                                if (errMsg != null) {
                                    request.setAttribute("errorMessage", errMsg);
                                }
                                if (!tmpFile.delete()) {
                                    logger.error("Unable to delete temp upload file");
                                }
                                throw throwable;
                            }
                            request.setAttribute("errorMessage", (Object)errMsg);
                        }
                        if (!tmpFile.delete()) {
                            logger.error("Unable to delete temp upload file");
                        }
                    }
                    request.setAttribute("errorMessage", (Object)errMsg);
                }
                if (!tmpFile.delete()) {
                    logger.error("Unable to delete temp upload file");
                }
            }
        }
        return new ModelAndView((View)new InternalResourceView(this.getViewName()));
    }

    @Override
    @Value(value="/adm/deploy.htm")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

