/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.deploy;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;
import psiprobe.controllers.AbstractTomcatContainerController;

@Controller
public class DeployContextController
extends AbstractTomcatContainerController {
    @RequestMapping(path={"/adm/deploycontext.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String contextName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"context", null);
        if (contextName != null) {
            try {
                if (this.getContainerWrapper().getTomcatContainer().installContext(contextName)) {
                    request.setAttribute("successMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.deploy.context.success", new Object[]{contextName}));
                    Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                    String name = auth.getName();
                    this.logger.info(this.getMessageSourceAccessor().getMessage("probe.src.log.deploycontext"), (Object)name, (Object)contextName);
                } else {
                    request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.deploy.context.failure", new Object[]{contextName}));
                }
            }
            catch (Exception e) {
                request.setAttribute("errorMessage", (Object)e.getMessage());
                this.logger.trace("", (Throwable)e);
            }
        }
        return new ModelAndView((View)new InternalResourceView(this.getViewName()));
    }

    @Override
    @Value(value="/adm/deploy.htm")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

