/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.jsp;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import psiprobe.controllers.AbstractContextHandlerController;
import psiprobe.model.jsp.Summary;

@Controller
public class DisplayJspController
extends AbstractContextHandlerController {
    public static final String SUMMARY_ATTRIBUTE = "jsp.summary";

    @RequestMapping(path={"/app/jsp.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean compile = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"compile", (boolean)false);
        HttpSession session = request.getSession(false);
        Summary summary = (Summary)session.getAttribute(SUMMARY_ATTRIBUTE);
        if (summary == null || !contextName.equals(summary.getName())) {
            summary = new Summary();
            summary.setName(contextName);
        }
        this.getContainerWrapper().getTomcatContainer().listContextJsps(context, summary, compile);
        request.getSession(false).setAttribute(SUMMARY_ATTRIBUTE, (Object)summary);
        if (compile) {
            return new ModelAndView((View)new RedirectView(request.getRequestURI() + "?webapp=" + (contextName.length() == 0 ? "/" : contextName)));
        }
        return new ModelAndView(this.getViewName(), "summary", (Object)summary);
    }

    @Override
    @Value(value="showjsps")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

