/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.jsp;

import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.jasper.EmbeddedServletOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.Utils;
import psiprobe.controllers.AbstractContextHandlerController;
import psiprobe.model.jsp.Item;
import psiprobe.model.jsp.Summary;

@Controller
public class ViewSourceController
extends AbstractContextHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(ViewSourceController.class);

    @RequestMapping(path={"/app/viewsource.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String jspName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"source", null);
        boolean highlight = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"highlight", (boolean)true);
        Summary summary = (Summary)(request.getSession(false) != null ? request.getSession(false).getAttribute("jsp.summary") : null);
        if (jspName != null && summary != null && contextName.equals(summary.getName())) {
            Item item = summary.getItems().get(jspName);
            if (item != null) {
                jspName = jspName.replaceAll("\\\\", "/");
                while (jspName.contains("../")) {
                    jspName = jspName.replaceAll("\\.\\./", "");
                }
                if (this.getContainerWrapper().getTomcatContainer().resourceExists(jspName, context)) {
                    Throwable throwable;
                    ServletContext sctx = context.getServletContext();
                    ServletConfig scfg = (ServletConfig)context.findChild("jsp");
                    EmbeddedServletOptions opt = new EmbeddedServletOptions(scfg, sctx);
                    String descriptorPageEncoding = opt.getJspConfig().findJspProperty(jspName).getPageEncoding();
                    if (descriptorPageEncoding != null && descriptorPageEncoding.length() > 0) {
                        item.setEncoding(descriptorPageEncoding);
                    } else {
                        throwable = null;
                        try (InputStream encodedStream = this.getContainerWrapper().getTomcatContainer().getResourceStream(jspName, context);){
                            item.setEncoding(Utils.getJspEncoding(encodedStream));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    throwable = null;
                    try (InputStream jspStream = this.getContainerWrapper().getTomcatContainer().getResourceStream(jspName, context);){
                        if (highlight) {
                            request.setAttribute("highlightedContent", (Object)Utils.highlightStream(jspName, jspStream, "xhtml", item.getEncoding()));
                        }
                        request.setAttribute("content", (Object)Utils.readStream(jspStream, item.getEncoding()));
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                } else {
                    logger.error("{} does not exist", (Object)jspName);
                }
                request.setAttribute("item", (Object)item);
            } else {
                logger.error("jsp name passed is not in the summary, ignored");
            }
        } else {
            if (jspName == null) {
                logger.error("Passed empty 'source' parameter");
            }
            if (summary == null) {
                logger.error("Session has expired or there is no summary");
            }
        }
        return new ModelAndView(this.getViewName());
    }

    @Override
    @Value(value="view_jsp_source")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

