/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.logs;

import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import psiprobe.beans.LogResolverBean;
import psiprobe.tools.logging.LogDestination;

public abstract class AbstractLogHandlerController
extends ParameterizableViewController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLogHandlerController.class);
    @Inject
    private LogResolverBean logResolver;

    public LogResolverBean getLogResolver() {
        return this.logResolver;
    }

    public void setLogResolver(LogResolverBean logResolver) {
        this.logResolver = logResolver;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String logType = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"logType");
        String webapp = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"webapp");
        boolean context = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"context", (boolean)false);
        boolean root = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"root", (boolean)false);
        String logName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"logName");
        String logIndex = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"logIndex");
        LogDestination dest = this.logResolver.getLogDestination(logType, webapp, context, root, logName, logIndex);
        ModelAndView modelAndView = null;
        boolean logFound = false;
        if (dest != null) {
            if (dest.getFile() != null && dest.getFile().exists()) {
                modelAndView = this.handleLogFile(request, response, dest);
                logFound = true;
            } else {
                logger.error("{}: file not found", (Object)dest.getFile());
            }
        } else {
            logger.error("{}{} log{} not found", new Object[]{logType, root ? " root" : "", root ? "" : " '" + logName + "'"});
        }
        if (!logFound) {
            response.sendError(404);
        }
        return modelAndView;
    }

    protected abstract ModelAndView handleLogFile(HttpServletRequest var1, HttpServletResponse var2, LogDestination var3) throws Exception;
}

