/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.logs;

import java.io.File;
import java.util.LinkedList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.controllers.logs.AbstractLogHandlerController;
import psiprobe.tools.BackwardsFileStream;
import psiprobe.tools.BackwardsLineReader;
import psiprobe.tools.logging.LogDestination;

@Controller
public class FollowController
extends AbstractLogHandlerController {
    @RequestMapping(path={"/follow.ajax"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    @Override
    protected ModelAndView handleLogFile(HttpServletRequest request, HttpServletResponse response, LogDestination logDest) throws Exception {
        ModelAndView mv = new ModelAndView(this.getViewName());
        File file = logDest.getFile();
        if (file.exists()) {
            LinkedList<String> lines = new LinkedList<String>();
            long actualLength = file.length();
            long lastKnownLength = ServletRequestUtils.getLongParameter((ServletRequest)request, (String)"lastKnownLength", (long)0L);
            long currentLength = ServletRequestUtils.getLongParameter((ServletRequest)request, (String)"currentLength", (long)actualLength);
            long maxReadLines = ServletRequestUtils.getLongParameter((ServletRequest)request, (String)"maxReadLines", (long)0L);
            if (lastKnownLength > currentLength || lastKnownLength > actualLength || currentLength > actualLength) {
                lastKnownLength = 0L;
                lines.add(" ------------- THE FILE HAS BEEN TRUNCATED --------------");
            }
            try (BackwardsFileStream bfs = new BackwardsFileStream(file, currentLength);){
                String line;
                BackwardsLineReader br = logDest.getEncoding() != null ? new BackwardsLineReader(bfs, logDest.getEncoding()) : new BackwardsLineReader(bfs);
                long readSize = 0L;
                long totalReadSize = currentLength - lastKnownLength;
                while (readSize < totalReadSize && (line = br.readLine()) != null) {
                    if (!line.isEmpty()) {
                        lines.addFirst(line);
                        readSize += (long)line.length();
                    } else {
                        ++readSize;
                    }
                    if (maxReadLines == 0L || (long)lines.size() < maxReadLines) continue;
                }
                if (lastKnownLength != 0L && readSize > totalReadSize) {
                    lines.removeFirst();
                }
            }
            mv.addObject("lines", lines);
        }
        return mv;
    }

    @Value(value="ajax/follow")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

