/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.logs;

import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import psiprobe.beans.LogResolverBean;
import psiprobe.tools.logging.LogDestination;

@Controller
public class ListLogsController
extends ParameterizableViewController {
    private String errorView;
    @Inject
    private LogResolverBean logResolver;

    public String getErrorView() {
        return this.errorView;
    }

    @Value(value="logs_notsupported")
    public void setErrorView(String errorView) {
        this.errorView = errorView;
    }

    public LogResolverBean getLogResolver() {
        return this.logResolver;
    }

    public void setLogResolver(LogResolverBean logResolver) {
        this.logResolver = logResolver;
    }

    @RequestMapping(path={"/logs", "/list.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean showAll = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"apps", (boolean)false);
        List<LogDestination> uniqueList = this.logResolver.getLogDestinations(showAll);
        if (uniqueList != null) {
            return new ModelAndView(this.getViewName()).addObject("logs", uniqueList);
        }
        return new ModelAndView(this.errorView);
    }

    @Value(value="logs")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

