/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.oshi;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import oshi.PlatformEnum;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Display;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.PowerSource;
import oshi.hardware.Sensors;
import oshi.hardware.SoundCard;
import oshi.hardware.UsbDevice;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSFileStore;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.Util;
import psiprobe.controllers.AbstractTomcatContainerController;

@Controller
public class OshiController
extends AbstractTomcatContainerController {
    private static final Logger logger = LoggerFactory.getLogger(OshiController.class);
    private static List<String> oshi = new ArrayList<String>();

    @RequestMapping(path={"/adm/oshi.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!oshi.isEmpty()) {
            ModelAndView mv = new ModelAndView(this.getViewName());
            mv.addObject("oshi", oshi);
            return mv;
        }
        oshi.add("Oshi results are performed as a system dump to screen here using Oshi SystemInfoTest logic.");
        oshi.add("Please be advised this is experimental in use and is slow. Resulting data is entirely cached.");
        oshi.add("Issues with library should be directed to https://github.com/oshi/oshi");
        oshi.add("For issues with our library usage of Oshi, please submit pull requests");
        oshi.add("");
        oshi.add("");
        this.initialize();
        ModelAndView mv = new ModelAndView(this.getViewName());
        mv.addObject("oshi", oshi);
        return mv;
    }

    @Override
    @Value(value="oshi")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }

    private void initialize() {
        logger.debug("Initializing System...");
        SystemInfo si = new SystemInfo();
        if (PlatformEnum.UNKNOWN.equals((Object)SystemInfo.getCurrentPlatformEnum())) {
            logger.error("Oshi not supported on current platform");
            oshi.add("Oshi not supported on current platform");
            oshi.add("");
            return;
        }
        HardwareAbstractionLayer hal = si.getHardware();
        OperatingSystem os = si.getOperatingSystem();
        OshiController.printOperatingSystem(os);
        logger.debug("Checking computer system...");
        OshiController.printComputerSystem(hal.getComputerSystem());
        logger.debug("Checking Processor...");
        OshiController.printProcessor(hal.getProcessor());
        logger.debug("Checking Memory...");
        OshiController.printMemory(hal.getMemory());
        logger.debug("Checking CPU...");
        OshiController.printCpu(hal.getProcessor());
        logger.debug("Checking Processes...");
        OshiController.printProcesses(os, hal.getMemory());
        logger.debug("Checking Services...");
        OshiController.printServices(os);
        logger.debug("Checking Sensors...");
        OshiController.printSensors(hal.getSensors());
        logger.debug("Checking Power sources...");
        OshiController.printPowerSources(hal.getPowerSources());
        logger.debug("Checking Disks...");
        OshiController.printDisks(hal.getDiskStores());
        logger.debug("Checking File System...");
        OshiController.printFileSystem(os.getFileSystem());
        logger.debug("Checking Network interfaces...");
        OshiController.printNetworkInterfaces(hal.getNetworkIFs());
        logger.debug("Checking Network parameters...");
        OshiController.printNetworkParameters(os.getNetworkParams());
        logger.debug("Checking Displays...");
        OshiController.printDisplays(hal.getDisplays());
        logger.debug("Checking USB Devices...");
        OshiController.printUsbDevices(hal.getUsbDevices(true));
        logger.debug("Checking Sound Cards...");
        OshiController.printSoundCards(hal.getSoundCards());
        oshi.add("Finished Operating System and Hardware Info Dump");
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < oshi.size(); ++i) {
            output.append(oshi.get(i));
            if (oshi.get(i) == null || oshi.get(i).equals("\n")) continue;
            output.append('\n');
        }
        logger.info("Printing Operating System and Hardware Info:{}{}", (Object)Character.valueOf('\n'), (Object)output);
    }

    private static void printOperatingSystem(OperatingSystem operatingSystem) {
        oshi.add(String.valueOf(operatingSystem));
        oshi.add("Booted: " + Instant.ofEpochSecond(operatingSystem.getSystemBootTime()));
        oshi.add("Uptime: " + FormatUtil.formatElapsedSecs((long)operatingSystem.getSystemUptime()));
        oshi.add("Running with" + (operatingSystem.isElevated() ? "" : "out") + " elevated permissions.");
    }

    private static void printComputerSystem(ComputerSystem computerSystem) {
        oshi.add("system: " + computerSystem.toString());
        oshi.add(" firmware: " + computerSystem.getFirmware().toString());
        oshi.add(" baseboard: " + computerSystem.getBaseboard().toString());
    }

    private static void printProcessor(CentralProcessor processor) {
        oshi.add(processor.toString());
    }

    private static void printMemory(GlobalMemory memory) {
        oshi.add("Memory: \n " + memory.toString());
        VirtualMemory vm = memory.getVirtualMemory();
        oshi.add("Swap: \n " + vm.toString());
        PhysicalMemory[] pmArray = memory.getPhysicalMemory();
        if (pmArray.length > 0) {
            oshi.add("Physical Memory: ");
            for (PhysicalMemory pm : pmArray) {
                oshi.add(" " + pm.toString());
            }
        }
    }

    private static void printCpu(CentralProcessor processor) {
        long[] freqs;
        double[] load;
        oshi.add("Context Switches/Interrupts: " + processor.getContextSwitches() + " / " + processor.getInterrupts());
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        long[][] prevProcTicks = processor.getProcessorCpuLoadTicks();
        oshi.add("CPU, IOWait, and IRQ ticks @ 0 sec:" + Arrays.toString(prevTicks));
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        oshi.add("CPU, IOWait, and IRQ ticks @ 1 sec:" + Arrays.toString(ticks));
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        oshi.add(String.format("User: %.1f%% Nice: %.1f%% System: %.1f%% Idle: %.1f%% IOwait: %.1f%% IRQ: %.1f%% SoftIRQ: %.1f%% Steal: %.1f%%", 100.0 * (double)user / (double)totalCpu, 100.0 * (double)nice / (double)totalCpu, 100.0 * (double)sys / (double)totalCpu, 100.0 * (double)idle / (double)totalCpu, 100.0 * (double)iowait / (double)totalCpu, 100.0 * (double)irq / (double)totalCpu, 100.0 * (double)softirq / (double)totalCpu, 100.0 * (double)steal / (double)totalCpu));
        oshi.add(String.format("CPU load: %.1f%%", processor.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0));
        double[] loadAverage = processor.getSystemLoadAverage(3);
        oshi.add("CPU load averages:" + (loadAverage[0] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[0])) + (loadAverage[1] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[1])) + (loadAverage[2] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[2])));
        StringBuilder procCpu = new StringBuilder("CPU load per processor:");
        for (double avg : load = processor.getProcessorCpuLoadBetweenTicks(prevProcTicks)) {
            procCpu.append(String.format(" %.1f%%", avg * 100.0));
        }
        oshi.add(procCpu.toString());
        long freq = processor.getProcessorIdentifier().getVendorFreq();
        if (freq > 0L) {
            oshi.add("Vendor Frequency: " + FormatUtil.formatHertz((long)freq));
        }
        if ((freq = processor.getMaxFreq()) > 0L) {
            oshi.add("Max Frequency: " + FormatUtil.formatHertz((long)freq));
        }
        if ((freqs = processor.getCurrentFreq())[0] > 0L) {
            StringBuilder sb = new StringBuilder("Current Frequencies: ");
            for (int i = 0; i < freqs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(FormatUtil.formatHertz((long)freqs[i]));
            }
            oshi.add(sb.toString());
        }
    }

    private static void printProcesses(OperatingSystem os, GlobalMemory memory) {
        oshi.add("My PID: " + os.getProcessId() + " with affinity " + Long.toBinaryString(os.getProcessAffinityMask(os.getProcessId())));
        oshi.add("Processes: " + os.getProcessCount() + ", Threads: " + os.getThreadCount());
        List<OSProcess> procs = Arrays.asList(os.getProcesses(5, OperatingSystem.ProcessSort.CPU));
        oshi.add("   PID  %CPU %MEM     VSZ     RSS Name");
        for (int i = 0; i < procs.size() && i < 5; ++i) {
            OSProcess p = procs.get(i);
            oshi.add(String.format(" %5d %5.1f %4.1f %9s %9s %s", p.getProcessID(), 100.0 * (double)(p.getKernelTime() + p.getUserTime()) / (double)p.getUpTime(), 100.0 * (double)p.getResidentSetSize() / (double)memory.getTotal(), FormatUtil.formatBytes((long)p.getVirtualSize()), FormatUtil.formatBytes((long)p.getResidentSetSize()), p.getName()));
        }
    }

    private static void printServices(OperatingSystem os) {
        oshi.add("Services: ");
        oshi.add("   PID   State   Name");
        int i = 0;
        for (OSService s : os.getServices()) {
            if (!s.getState().equals((Object)OSService.State.RUNNING) || i++ >= 5) continue;
            oshi.add(String.format(" %5d  %7s  %s", s.getProcessID(), s.getState(), s.getName()));
        }
        i = 0;
        for (OSService s : os.getServices()) {
            if (!s.getState().equals((Object)OSService.State.STOPPED) || i++ >= 5) continue;
            oshi.add(String.format(" %5d  %7s  %s", s.getProcessID(), s.getState(), s.getName()));
        }
    }

    private static void printSensors(Sensors sensors) {
        oshi.add("Sensors: " + sensors.toString());
    }

    private static void printPowerSources(PowerSource[] powerSources) {
        StringBuilder sb = new StringBuilder("Power Sources: ");
        if (powerSources.length == 0) {
            sb.append("Unknown");
        }
        for (PowerSource powerSource : powerSources) {
            sb.append("\n ").append(powerSource.toString());
        }
        oshi.add(sb.toString());
    }

    private static void printDisks(HWDiskStore[] diskStores) {
        oshi.add("Disks:");
        for (HWDiskStore disk : diskStores) {
            HWPartition[] partitions;
            oshi.add(" " + disk.toString());
            for (HWPartition part : partitions = disk.getPartitions()) {
                oshi.add(" |-- " + part.toString());
            }
        }
    }

    private static void printFileSystem(FileSystem fileSystem) {
        OSFileStore[] fsArray;
        oshi.add("File System:");
        oshi.add(String.format(" File Descriptors: %d/%d", fileSystem.getOpenFileDescriptors(), fileSystem.getMaxFileDescriptors()));
        for (OSFileStore fs : fsArray = fileSystem.getFileStores()) {
            long usable = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            oshi.add(String.format(" %s (%s) [%s] %s of %s free (%.1f%%), %s of %s files free (%.1f%%) is %s " + (fs.getLogicalVolume() != null && fs.getLogicalVolume().length() > 0 ? "[%s]" : "%s") + " and is mounted at %s", fs.getName(), fs.getDescription().isEmpty() ? "file system" : fs.getDescription(), fs.getType(), FormatUtil.formatBytes((long)usable), FormatUtil.formatBytes((long)fs.getTotalSpace()), 100.0 * (double)usable / (double)total, FormatUtil.formatValue((long)fs.getFreeInodes(), (String)""), FormatUtil.formatValue((long)fs.getTotalInodes(), (String)""), 100.0 * (double)fs.getFreeInodes() / (double)fs.getTotalInodes(), fs.getVolume(), fs.getLogicalVolume(), fs.getMount()));
        }
    }

    private static void printNetworkInterfaces(NetworkIF[] networkIFs) {
        StringBuilder sb = new StringBuilder("Network Interfaces:");
        if (networkIFs.length == 0) {
            sb.append(" Unknown");
        }
        for (NetworkIF net : networkIFs) {
            sb.append("\n ").append(net.toString());
        }
        oshi.add(sb.toString());
    }

    private static void printNetworkParameters(NetworkParams networkParams) {
        oshi.add("Network parameters:\n " + networkParams.toString());
    }

    private static void printDisplays(Display[] displays) {
        oshi.add("Displays:");
        int i = 0;
        for (Display display : displays) {
            oshi.add(" Display " + i + ":");
            oshi.add(String.valueOf(display));
            ++i;
        }
    }

    private static void printUsbDevices(UsbDevice[] usbDevices) {
        oshi.add("USB Devices:");
        for (UsbDevice usbDevice : usbDevices) {
            oshi.add(String.valueOf(usbDevice));
        }
    }

    private static void printSoundCards(SoundCard[] cards) {
        oshi.add("Sound Cards:");
        for (SoundCard card : cards) {
            oshi.add(" " + String.valueOf(card));
        }
    }
}

