/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.catalina.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.controllers.AbstractContextHandlerController;

@Controller
public class ConnectionTestController
extends AbstractContextHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionTestController.class);

    @RequestMapping(path={"/sql/connection.ajax"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String resourceName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"resource");
        DataSource dataSource = null;
        try {
            dataSource = this.getContainerWrapper().getResourceResolver().lookupDataSource(context, resourceName, this.getContainerWrapper());
        }
        catch (NamingException e) {
            request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.resource.lookup.failure", new Object[]{resourceName}));
            logger.trace("", (Throwable)e);
        }
        if (dataSource == null) {
            request.setAttribute("errorMessage", (Object)this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.resource.lookup.failure", new Object[]{resourceName}));
            return new ModelAndView(this.getViewName());
        }
        try (Connection conn = dataSource.getConnection();){
            DatabaseMetaData md = conn.getMetaData();
            ArrayList<Map<String, String>> dbMetaData = new ArrayList<Map<String, String>>();
            this.addDbMetaDataEntry(dbMetaData, "probe.jsp.dataSourceTest.dbMetaData.dbProdName", md.getDatabaseProductName());
            this.addDbMetaDataEntry(dbMetaData, "probe.jsp.dataSourceTest.dbMetaData.dbProdVersion", md.getDatabaseProductVersion());
            this.addDbMetaDataEntry(dbMetaData, "probe.jsp.dataSourceTest.dbMetaData.jdbcDriverName", md.getDriverName());
            this.addDbMetaDataEntry(dbMetaData, "probe.jsp.dataSourceTest.dbMetaData.jdbcDriverVersion", md.getDriverVersion());
            this.addDbMetaDataEntry(dbMetaData, "probe.jsp.dataSourceTest.dbMetaData.jdbcVersion", String.valueOf(md.getJDBCMajorVersion()));
            ModelAndView modelAndView = new ModelAndView(this.getViewName(), "dbMetaData", dbMetaData);
            return modelAndView;
        }
        catch (SQLException e) {
            String message = this.getMessageSourceAccessor().getMessage("probe.src.dataSourceTest.connection.failure", new Object[]{e.getMessage()});
            logger.error(message, (Throwable)e);
            request.setAttribute("errorMessage", (Object)message);
        }
        return new ModelAndView(this.getViewName());
    }

    @Override
    protected boolean isContextOptional() {
        return true;
    }

    private void addDbMetaDataEntry(List<Map<String, String>> list, String name, String value) {
        LinkedHashMap<String, String> entry = new LinkedHashMap<String, String>();
        entry.put("propertyName", this.getMessageSourceAccessor().getMessage(name));
        entry.put("propertyValue", value);
        list.add(entry);
    }

    @Override
    @Value(value="ajax/sql/connection")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

