/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.sql;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import psiprobe.model.sql.DataSourceTestInfo;
import psiprobe.tools.TimeExpression;

@Controller
public class DataSourceTestController
extends ParameterizableViewController {
    private int maxRows;
    private int rowsPerPage;
    private int historySize;
    private String replacePattern;
    private long collectionPeriod;

    @RequestMapping(path={"/sql/datasourcetest.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String referer;
        HttpSession sess = request.getSession(false);
        DataSourceTestInfo sessData = null;
        if (sess != null) {
            sessData = (DataSourceTestInfo)sess.getAttribute("dataSourceTestData");
        }
        String backUrl = (referer = request.getHeader("Referer")) != null ? referer.replaceAll(this.replacePattern, "") : null;
        return new ModelAndView(this.getViewName()).addObject("maxRows", (Object)String.valueOf(sessData == null ? this.getMaxRows() : sessData.getMaxRows())).addObject("rowsPerPage", (Object)String.valueOf(sessData == null ? this.getRowsPerPage() : sessData.getRowsPerPage())).addObject("historySize", (Object)String.valueOf(sessData == null ? this.getHistorySize() : sessData.getHistorySize())).addObject("backURL", (Object)backUrl).addObject("collectionPeriod", (Object)this.getCollectionPeriod());
    }

    public long getCollectionPeriod() {
        return this.collectionPeriod;
    }

    public void setCollectionPeriod(long collectionPeriod) {
        this.collectionPeriod = collectionPeriod;
    }

    @Value(value="${psiprobe.beans.stats.collectors.connector.period}")
    public void setCollectionPeriod(String collectionPeriod) {
        this.collectionPeriod = TimeExpression.inSeconds(collectionPeriod);
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    @Value(value="1000")
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @Value(value="50")
    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    @Value(value="30")
    public void setHistorySize(int historySize) {
        this.historySize = historySize;
    }

    public String getReplacePattern() {
        return this.replacePattern;
    }

    @Value(value="^http(s)?://[a-zA-Z\\-\\.0-9]+(:[0-9]+)?")
    public void setReplacePattern(String replacePattern) {
        this.replacePattern = replacePattern;
    }

    @Value(value="datasourcetest")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

