/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.sql;

import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import psiprobe.model.sql.DataSourceTestInfo;

@Controller
public class QueryHistoryItemController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(QueryHistoryItemController.class);

    @RequestMapping(path={"/sql/queryHistoryItem.ajax"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<String> queryHistory;
        DataSourceTestInfo sessData;
        int sqlId = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"sqlId", (int)-1);
        HttpSession sess = request.getSession(false);
        if (sess != null && (sessData = (DataSourceTestInfo)sess.getAttribute("dataSourceTestData")) != null && (queryHistory = sessData.getQueryHistory()) != null) {
            try {
                String sql = queryHistory.get(sqlId);
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                response.getWriter().print(sql);
            }
            catch (IndexOutOfBoundsException e) {
                logger.error("Cannot find a query history entry for history item id = {}", (Object)sqlId);
                logger.trace("", (Throwable)e);
            }
        }
        return null;
    }
}

