/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.threads;

import java.net.URLClassLoader;
import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import psiprobe.Utils;

@Controller
public class GetClassLoaderUrlsController
extends ParameterizableViewController {
    private static final Logger logger = LoggerFactory.getLogger(GetClassLoaderUrlsController.class);

    @RequestMapping(path={"/cldetails.ajax"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ClassLoader cl;
        String threadName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"thread", null);
        Thread thread = Utils.getThreadByName(threadName);
        if (thread != null && (cl = thread.getContextClassLoader()) != null && cl instanceof URLClassLoader) {
            try {
                request.setAttribute("urls", Arrays.asList(((URLClassLoader)cl).getURLs()));
            }
            catch (Exception e) {
                logger.error("There was an exception querying classloader for thread '{}'", (Object)threadName, (Object)e);
            }
        }
        return new ModelAndView(this.getViewName());
    }

    @Value(value="ajax/classLoaderDetails")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

