/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.controllers.AbstractTomcatContainerController;
import psiprobe.model.java.ThreadModel;
import psiprobe.tools.Instruments;

@Controller
public class ListThreadsController
extends AbstractTomcatContainerController {
    @RequestMapping(path={"/th_impl1.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<Context> contexts = this.getContainerWrapper().getTomcatContainer().findContexts();
        TreeMap<String, String> classLoaderMap = new TreeMap<String, String>();
        for (Context context : contexts) {
            if (context.getLoader() == null || context.getLoader().getClassLoader() == null) continue;
            classLoaderMap.put(ListThreadsController.toUid(context.getLoader().getClassLoader()), context.getName());
        }
        return new ModelAndView(this.getViewName(), "threads", this.enumerateThreads(classLoaderMap));
    }

    private List<ThreadModel> enumerateThreads(Map<String, String> classLoaderMap) {
        ThreadGroup masterGroup = Thread.currentThread().getThreadGroup();
        while (masterGroup.getParent() != null) {
            masterGroup = masterGroup.getParent();
        }
        ArrayList<ThreadModel> threadList = new ArrayList<ThreadModel>();
        Thread[] threads = new Thread[masterGroup.activeCount()];
        int numThreads = masterGroup.enumerate(threads);
        for (int i = 0; i < numThreads; ++i) {
            ClassLoader cl;
            Object target;
            ThreadModel threadModel = new ThreadModel();
            threadModel.setThreadClass(threads[i].getClass().getName());
            threadModel.setName(threads[i].getName());
            threadModel.setPriority(threads[i].getPriority());
            threadModel.setDaemon(threads[i].isDaemon());
            threadModel.setInterrupted(threads[i].isInterrupted());
            if (threads[i].getThreadGroup() != null) {
                threadModel.setGroupName(threads[i].getThreadGroup().getName());
            }
            if ((target = Instruments.getField(threads[i], "target")) != null) {
                threadModel.setRunnableClassName(target.getClass().getName());
            }
            if ((cl = threads[i].getContextClassLoader()) != null) {
                if (classLoaderMap != null) {
                    threadModel.setAppName(classLoaderMap.get(ListThreadsController.toUid(cl)));
                }
                threadModel.setClassLoader(ListThreadsController.toUid(cl));
            }
            threadList.add(threadModel);
        }
        return threadList;
    }

    private static String toUid(Object obj) {
        return obj.getClass().getName() + "@" + obj.hashCode();
    }

    @Override
    @Value(value="threads")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

