/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.mappers;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class AjaxDecoratorMapper
extends AbstractDecoratorMapper {
    private String ajaxExtension = ".ajax";

    public void init(Config config, Properties properties, DecoratorMapper decoratorMapper) throws InstantiationException {
        super.init(config, properties, decoratorMapper);
        if (properties.get("ajaxExtension") != null) {
            this.ajaxExtension = (String)properties.get("ajaxExtension");
        }
    }

    public Decorator getDecorator(HttpServletRequest request, Page page) {
        int queryStringIndex;
        String originalUri = (String)request.getAttribute("javax.servlet.error.request_uri");
        if (originalUri != null && (queryStringIndex = originalUri.indexOf(63)) != -1) {
            originalUri = originalUri.substring(0, queryStringIndex);
        }
        boolean callMapperChain = (originalUri == null || !originalUri.endsWith(this.ajaxExtension)) && !request.getServletPath().endsWith(this.ajaxExtension);
        return callMapperChain ? super.getDecorator(request, page) : null;
    }
}

