/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSearchInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SessionSearchInfo.class);
    public static final String SESS_ATTR_NAME = "sessionSearchInfo";
    public static final String ACTION_NONE = "none";
    public static final String ACTION_APPLY = "apply";
    public static final String ACTION_CLEAR = "clear";
    private String searchAction = "none";
    private boolean apply;
    private boolean clear;
    private String sessionId;
    private Pattern sessionIdPattern;
    private String sessionIdMsg;
    private String attrName;
    private final List<Pattern> attrNamePatterns = new ArrayList<Pattern>();
    private final List<String> attrNameMsgs = new ArrayList<String>();
    private String ageFrom;
    private Integer ageFromSec;
    private String ageTo;
    private Integer ageToSec;
    private String idleTimeFrom;
    private Integer idleTimeFromSec;
    private String idleTimeTo;
    private Integer idleTimeToSec;
    private String lastIp;
    private String infoMessage;
    private final List<String> errorMessages = new ArrayList<String>();

    public boolean isEmpty() {
        return this.sessionId == null && this.attrName == null && this.ageFrom == null && this.ageTo == null && this.idleTimeFrom == null && this.idleTimeTo == null && this.lastIp == null;
    }

    public boolean isSessionIdValid() {
        return this.sessionId == null || this.sessionIdPattern != null;
    }

    public boolean isAttrNameValid() {
        return this.attrName == null || !this.attrNamePatterns.isEmpty();
    }

    public boolean isAgeFromValid() {
        return this.ageFrom == null || this.ageFromSec != null;
    }

    public boolean isAgeToValid() {
        return this.ageTo == null || this.ageToSec != null;
    }

    public boolean isIdleTimeFromValid() {
        return this.idleTimeFrom == null || this.idleTimeFromSec != null;
    }

    public boolean isIdleTimeToValid() {
        return this.idleTimeTo == null || this.idleTimeToSec != null;
    }

    public boolean isValid() {
        return this.isSessionIdValid() && this.isAttrNameValid() && this.isAgeFromValid() && this.isAgeToValid() && this.isIdleTimeFromValid() && this.isIdleTimeToValid();
    }

    public boolean isUseSearch() {
        return this.isApply() && !this.isEmpty() && this.isValid();
    }

    public boolean isUseSessionId() {
        return this.sessionIdPattern != null;
    }

    public boolean isUseAttrName() {
        return !this.attrNamePatterns.isEmpty();
    }

    public boolean isUseAttr() {
        return this.isUseSearch() && this.isUseAttrName();
    }

    public boolean isUseAgeFrom() {
        return this.ageFromSec != null;
    }

    public boolean isUseAgeTo() {
        return this.ageToSec != null;
    }

    public boolean isUseIdleTimeFrom() {
        return this.idleTimeFromSec != null;
    }

    public boolean isUseIdleTimeTo() {
        return this.idleTimeToSec != null;
    }

    public boolean isUseLastIp() {
        return this.lastIp != null;
    }

    public String getSearchAction() {
        return this.searchAction;
    }

    public void setSearchAction(String searchAction) {
        this.searchAction = searchAction;
        if (searchAction == null) {
            this.apply = false;
            this.clear = false;
        } else {
            this.apply = ACTION_APPLY.equals(searchAction);
            this.clear = ACTION_CLEAR.equals(searchAction);
        }
    }

    public boolean isApply() {
        return this.apply;
    }

    public boolean isClear() {
        return this.clear;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.sessionIdPattern = null;
        this.sessionIdMsg = null;
        if (sessionId != null) {
            try {
                this.sessionIdPattern = Pattern.compile(sessionId);
            }
            catch (PatternSyntaxException e) {
                logger.trace("", (Throwable)e);
                this.sessionIdMsg = e.getDescription();
            }
        }
    }

    public Pattern getSessionIdPattern() {
        return this.sessionIdPattern;
    }

    public String getSessionIdMsg() {
        return this.sessionIdMsg;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
        this.attrNamePatterns.clear();
        this.attrNameMsgs.clear();
        if (attrName != null) {
            String[] attrNames = attrName.split(",");
            if (attrNames.length == 0 && !attrName.isEmpty()) {
                this.attrNameMsgs.add("");
            } else {
                for (String regex : attrNames) {
                    try {
                        this.attrNamePatterns.add(Pattern.compile(regex));
                    }
                    catch (PatternSyntaxException e) {
                        logger.trace("", (Throwable)e);
                        this.attrNameMsgs.add(e.getDescription());
                    }
                }
            }
        }
    }

    public List<Pattern> getAttrNamePatterns() {
        return this.attrNamePatterns;
    }

    public List<String> getAttrNameMsgs() {
        return this.attrNameMsgs;
    }

    public String getAgeFrom() {
        return this.ageFrom;
    }

    public void setAgeFrom(String ageFrom) {
        this.ageFrom = ageFrom;
        this.ageFromSec = null;
        if (ageFrom != null) {
            try {
                this.ageFromSec = Integer.valueOf(ageFrom);
            }
            catch (NumberFormatException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    public Integer getAgeFromSec() {
        return this.ageFromSec;
    }

    public String getAgeTo() {
        return this.ageTo;
    }

    public void setAgeTo(String ageTo) {
        this.ageTo = ageTo;
        this.ageToSec = null;
        if (ageTo != null) {
            try {
                this.ageToSec = Integer.valueOf(ageTo);
            }
            catch (NumberFormatException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    public Integer getAgeToSec() {
        return this.ageToSec;
    }

    public String getIdleTimeFrom() {
        return this.idleTimeFrom;
    }

    public void setIdleTimeFrom(String idleTimeFrom) {
        this.idleTimeFrom = idleTimeFrom;
        this.idleTimeFromSec = null;
        if (idleTimeFrom != null) {
            try {
                this.idleTimeFromSec = Integer.valueOf(idleTimeFrom);
            }
            catch (NumberFormatException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    public Integer getIdleTimeFromSec() {
        return this.idleTimeFromSec;
    }

    public String getIdleTimeTo() {
        return this.idleTimeTo;
    }

    public void setIdleTimeTo(String idleTimeTo) {
        this.idleTimeTo = idleTimeTo;
        this.idleTimeToSec = null;
        if (idleTimeTo != null) {
            try {
                this.idleTimeToSec = Integer.valueOf(idleTimeTo);
            }
            catch (NumberFormatException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    public Integer getIdleTimeToSec() {
        return this.idleTimeToSec;
    }

    public String getLastIp() {
        return this.lastIp;
    }

    public void setLastIp(String lastIp) {
        this.lastIp = lastIp;
    }

    public String getInfoMessage() {
        return this.infoMessage;
    }

    public void setInfoMessage(String infoMessage) {
        this.infoMessage = infoMessage;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void addErrorMessage(String msg) {
        this.errorMessages.add(msg);
    }
}

