/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tokenizer;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.tokenizer.Token;
import psiprobe.tokenizer.TokenizerSymbol;
import psiprobe.tokenizer.UniqueList;

public class Tokenizer {
    private static final Logger logger = LoggerFactory.getLogger(Tokenizer.class);
    public static final int TT_TOKEN = 0;
    public static final int TT_SYMBOL = 1;
    public static final int TT_BLOCK = 2;
    public static final int TT_ERROR = 3;
    private Reader reader;
    private final List<TokenizerSymbol> symbols = new UniqueList<TokenizerSymbol>();
    private int pushCount;
    private final TokenizerToken token = new TokenizerToken();
    private final TokenizerToken upcomingToken = new TokenizerToken();
    private int cachePosition;
    private int cacheSize;
    private final char[] cacheBuffer;
    private int cachePinPosition;

    public Tokenizer() {
        this(null, 4096);
    }

    public Tokenizer(Reader reader) {
        this(reader, 4096);
    }

    public Tokenizer(Reader reader, int cacheBufferSize) {
        this.cacheBuffer = new char[cacheBufferSize];
        this.setReader(reader);
    }

    private void loadCache(int count) throws IOException {
        int charToRead;
        int n = charToRead = count == 0 ? 0 : count - 1;
        if (this.cachePosition + charToRead >= this.cacheSize) {
            if (this.cacheSize == 0) {
                this.cacheSize = this.reader.read(this.cacheBuffer, 0, this.cacheBuffer.length);
                this.cachePosition = 0;
            } else if (this.cacheSize == this.cacheBuffer.length) {
                int charsRead;
                int halfCacheSize = this.cacheSize / 2;
                System.arraycopy(this.cacheBuffer, halfCacheSize, this.cacheBuffer, 0, halfCacheSize);
                this.cachePosition -= halfCacheSize;
                if (this.cachePinPosition != -1) {
                    this.cachePinPosition -= halfCacheSize;
                }
                this.cacheSize = (charsRead = this.reader.read(this.cacheBuffer, halfCacheSize, this.cacheSize - halfCacheSize)) == -1 ? halfCacheSize : charsRead + halfCacheSize;
            }
        }
    }

    public Token getToken() throws IOException {
        if (this.token.type == 3) {
            return this.nextToken();
        }
        return this.token;
    }

    public Token nextToken() throws IOException {
        if (this.pushCount > 0) {
            --this.pushCount;
            return this.token;
        }
        if (this.upcomingToken.type != 3) {
            this.token.assign(this.upcomingToken);
            this.upcomingToken.type = 3;
            return this.token;
        }
        this.token.init();
        char[] chr = new char[1];
        while (this.hasMore()) {
            this.read(chr, 1);
            int symbolIndex = this.lookupSymbol(chr[0]);
            if (symbolIndex != -1) {
                TokenizerToken workToken = this.token.type == 0 && this.token.text.length() > 0 ? this.upcomingToken : this.token;
                TokenizerSymbol symbol = this.symbols.get(symbolIndex);
                boolean hideSymbol = symbol.hidden;
                if (!hideSymbol) {
                    workToken.init();
                    workToken.text.append(symbol.startText);
                    workToken.type = 1;
                    workToken.name = symbol.name;
                }
                if (symbol.tailText != null) {
                    while (this.hasMore() && !this.compare(symbol.tailText.toCharArray(), 0)) {
                        this.read(chr, 1);
                        if (hideSymbol) continue;
                        workToken.text.append(chr);
                        workToken.innerText.append(chr);
                    }
                    if (!hideSymbol) {
                        workToken.text.append(symbol.tailText);
                    }
                    workToken.type = 2;
                }
                if (this.token.text.length() <= 0) continue;
                break;
            }
            this.token.text.append(chr);
            this.token.type = 0;
        }
        return this.token;
    }

    public void pushBack() {
        ++this.pushCount;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
        this.cachePosition = 0;
        this.cachePinPosition = -1;
        this.cacheSize = 0;
        this.token.type = 3;
        this.upcomingToken.type = 3;
    }

    private boolean compare(char[] chars, int offs) throws IOException {
        char[] subStr = new char[chars.length - offs];
        this.cachePinPosition = this.cachePosition;
        this.read(subStr, subStr.length);
        for (int i = 0; i < subStr.length; ++i) {
            if (subStr[i] == chars[i + offs]) continue;
            this.cachePosition = this.cachePinPosition;
            this.cachePinPosition = -1;
            return false;
        }
        return true;
    }

    private int lookupSymbol(char chr) throws IOException {
        int result = -1;
        Character chrObj = Character.valueOf(chr);
        int index = Collections.binarySearch(this.symbols, chrObj);
        if (index >= 0) {
            TokenizerSymbol symbol;
            while (index > 0 && this.symbols.get(index - 1).compareTo(chrObj) == 0) {
                --index;
            }
            while (index < this.symbols.size() && (symbol = this.symbols.get(index)).compareTo(chrObj) == 0) {
                if (this.compare(symbol.startText.toCharArray(), 1)) {
                    result = index;
                    break;
                }
                ++index;
            }
        }
        return result;
    }

    private void read(char[] chrs, int count) throws IOException {
        int endPoint;
        this.loadCache(count);
        int n = endPoint = this.cachePosition + count - 1 >= this.cacheSize ? this.cacheSize : this.cachePosition + count - 1;
        if (this.cachePosition <= endPoint) {
            System.arraycopy(this.cacheBuffer, this.cachePosition, chrs, 0, endPoint - this.cachePosition + 1);
        }
        this.cachePosition = endPoint + 1;
    }

    public boolean hasMore() throws IOException {
        this.loadCache(0);
        return this.cachePosition < this.cacheSize || this.upcomingToken.type != 3 || this.pushCount > 0;
    }

    public void addSymbol(String text) {
        this.symbols.add(new TokenizerSymbol(null, text, null, false, false, true, false));
    }

    public void addSymbol(String text, boolean hidden) {
        this.symbols.add(new TokenizerSymbol(null, text, null, hidden, false, true, false));
    }

    public void addSymbol(String startText, String endText, boolean hidden) {
        this.symbols.add(new TokenizerSymbol(null, startText, endText, hidden, false, true, false));
    }

    public void addSymbol(TokenizerSymbol symbol) {
        this.symbols.add(symbol);
    }

    public String getNextString(String defaultValue) throws IOException {
        return this.hasMore() ? this.nextToken().getInnerText() : defaultValue;
    }

    public boolean getNextBoolean(String trueValue, boolean defaultValue) throws IOException {
        return this.hasMore() ? trueValue.equalsIgnoreCase(this.nextToken().getInnerText()) : defaultValue;
    }

    public long getNextLong(long defaultValue) throws IOException {
        String stval = this.getNextString(null);
        if (stval == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(stval);
        }
        catch (NumberFormatException e) {
            logger.trace("", (Throwable)e);
            return defaultValue;
        }
    }

    private static class TokenizerToken
    implements Token {
        final StringBuilder text = new StringBuilder();
        final StringBuilder innerText = new StringBuilder();
        String name = "";
        int type = 3;
        int line = 0;
        int col = 0;

        @Override
        public String getText() {
            return this.text.toString();
        }

        @Override
        public String getInnerText() {
            return this.type == 2 ? this.innerText.toString() : this.getText();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getCol() {
            return this.col;
        }

        public String toString() {
            return this.getText();
        }

        public void assign(TokenizerToken token) {
            this.text.setLength(0);
            this.text.append((CharSequence)token.text);
            this.innerText.setLength(0);
            this.innerText.append((CharSequence)token.innerText);
            this.name = token.name;
            this.type = token.type;
            this.col = token.col;
            this.line = token.line;
        }

        public void init() {
            this.text.setLength(0);
            this.innerText.setLength(0);
            this.name = "";
        }
    }
}

