/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.tools.Accessor;
import psiprobe.tools.ReflectiveAccessor;
import psiprobe.tools.SimpleAccessor;

public class AccessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(AccessorFactory.class);

    private AccessorFactory() {
    }

    public static Accessor getInstance() {
        return AccessorFactory.getSimple();
    }

    private static Accessor getReflective() {
        try {
            return new ReflectiveAccessor();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.trace("", (Throwable)e);
            return null;
        }
    }

    private static Accessor getSimple() {
        return new SimpleAccessor();
    }
}

