/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardWrapper;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import psiprobe.beans.ContainerWrapperBean;
import psiprobe.beans.ResourceResolver;
import psiprobe.model.Application;
import psiprobe.model.ApplicationParam;
import psiprobe.model.ApplicationResource;
import psiprobe.model.ApplicationSession;
import psiprobe.model.Attribute;
import psiprobe.model.FilterInfo;
import psiprobe.model.ServletInfo;
import psiprobe.model.ServletMapping;
import psiprobe.tools.Instruments;

public final class ApplicationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationUtils.class);

    private ApplicationUtils() {
    }

    public static Application getApplication(Context context, ContainerWrapperBean containerWrapper) {
        return ApplicationUtils.getApplication(context, null, false, containerWrapper);
    }

    public static Application getApplication(Context context, ResourceResolver resourceResolver, boolean calcSize, ContainerWrapperBean containerWrapper) {
        logger.debug("Querying webapp: {}", (Object)context.getName());
        Application app = new Application();
        app.setName(context.getName().length() > 0 ? context.getName() : "/");
        app.setDocBase(context.getDocBase());
        app.setDisplayName(context.getDisplayName());
        app.setAvailable(containerWrapper.getTomcatContainer().getAvailable(context));
        app.setDistributable(context.getDistributable());
        app.setSessionTimeout(context.getSessionTimeout());
        app.setServletVersion(context.getServletContext().getMajorVersion() + "." + context.getServletContext().getMinorVersion());
        if (resourceResolver != null) {
            logger.debug("counting servlet attributes");
            app.setContextAttributeCount(Collections.list(context.getServletContext().getAttributeNames()).size());
            if (app.isAvailable()) {
                logger.debug("collecting session information");
                app.setSessionCount(context.getManager().findSessions().length);
                boolean serializable = true;
                long sessionAttributeCount = 0L;
                long size = 0L;
                for (Session session : context.getManager().findSessions()) {
                    ApplicationSession appSession = ApplicationUtils.getApplicationSession(session, calcSize, false);
                    if (appSession == null) continue;
                    sessionAttributeCount += appSession.getObjectCount();
                    serializable = serializable && appSession.isSerializable();
                    size += appSession.getSize();
                }
                app.setSerializable(serializable);
                app.setSessionAttributeCount(sessionAttributeCount);
                app.setSize(size);
            }
            logger.debug("aggregating servlet stats");
            ApplicationUtils.collectApplicationServletStats(context, app);
            if (resourceResolver.supportsPrivateResources() && app.isAvailable()) {
                int[] scores = ApplicationUtils.getApplicationDataSourceUsageScores(context, resourceResolver, containerWrapper);
                app.setDataSourceBusyScore(scores[0]);
                app.setDataSourceEstablishedScore(scores[1]);
            }
        }
        return app;
    }

    public static void collectApplicationServletStats(Context context, Application app) {
        int svltCount = 0;
        int reqCount = 0;
        int errCount = 0;
        long procTime = 0L;
        long minTime = Long.MAX_VALUE;
        long maxTime = 0L;
        for (Container container : context.findChildren()) {
            if (!(container instanceof StandardWrapper)) continue;
            StandardWrapper sw = (StandardWrapper)container;
            ++svltCount;
            reqCount += sw.getRequestCount();
            errCount += sw.getErrorCount();
            procTime += sw.getProcessingTime();
            if (sw.getRequestCount() > 0) {
                minTime = Math.min(minTime, sw.getMinTime());
            }
            maxTime = Math.max(maxTime, sw.getMaxTime());
        }
        app.setServletCount(svltCount);
        app.setRequestCount(reqCount);
        app.setErrorCount(errCount);
        app.setProcessingTime(procTime);
        app.setMinTime(minTime == Long.MAX_VALUE ? 0L : minTime);
        app.setMaxTime(maxTime);
    }

    public static int[] getApplicationDataSourceUsageScores(Context context, ResourceResolver resolver, ContainerWrapperBean containerWrapper) {
        List<ApplicationResource> appResources;
        logger.debug("Calculating datasource usage score");
        int[] scores = new int[]{0, 0};
        try {
            appResources = resolver.getApplicationResources(context, containerWrapper);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        for (ApplicationResource appResource : appResources) {
            if (appResource.getDataSourceInfo() == null) continue;
            scores[0] = Math.max(scores[0], appResource.getDataSourceInfo().getBusyScore());
            scores[1] = Math.max(scores[1], appResource.getDataSourceInfo().getEstablishedScore());
        }
        return scores;
    }

    public static ApplicationSession getApplicationSession(Session session, boolean calcSize, boolean addAttributes) {
        ApplicationSession sbean = null;
        if (session != null && session.isValid()) {
            sbean = new ApplicationSession();
            sbean.setId(session.getId());
            sbean.setCreationTime(new Date(session.getCreationTime()));
            sbean.setLastAccessTime(new Date(session.getLastAccessedTime()));
            sbean.setMaxIdleTime(session.getMaxInactiveInterval() * 1000);
            sbean.setManagerType(session.getManager().getClass().getName());
            try {
                Object info = MethodUtils.invokeMethod((Object)session, (String)"getInfo");
                sbean.setInfo(String.valueOf(info));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                sbean.setInfo(session.getClass().getSimpleName());
                logger.trace("Cannot determine session info for tomcat 8+", (Throwable)e);
            }
            boolean sessionSerializable = true;
            int attributeCount = 0;
            long size = 0L;
            HttpSession httpSession = session.getSession();
            HashSet<Object> processedObjects = new HashSet<Object>(1000);
            processedObjects.add(httpSession);
            try {
                for (String name : Collections.list(httpSession.getAttributeNames())) {
                    Object obj = httpSession.getAttribute(name);
                    sessionSerializable = sessionSerializable && obj instanceof Serializable;
                    long objSize = 0L;
                    if (calcSize) {
                        try {
                            objSize += Instruments.sizeOf((Object)name, processedObjects);
                            objSize += Instruments.sizeOf(obj, processedObjects);
                        }
                        catch (Exception ex) {
                            logger.error("Cannot estimate size of attribute '{}'", (Object)name, (Object)ex);
                        }
                    }
                    if (addAttributes) {
                        Attribute saBean = new Attribute();
                        saBean.setName(name);
                        saBean.setType(ClassUtils.getQualifiedName(obj.getClass()));
                        saBean.setValue(obj);
                        saBean.setSize(objSize);
                        saBean.setSerializable(obj instanceof Serializable);
                        sbean.addAttribute(saBean);
                    }
                    ++attributeCount;
                    size += objSize;
                }
                String lastAccessedIp = (String)httpSession.getAttribute("__psiprobe_la_ip");
                if (lastAccessedIp != null) {
                    sbean.setLastAccessedIp(lastAccessedIp);
                    sbean.setLastAccessedIpLocale((Locale)httpSession.getAttribute("__psiprobe_la_local"));
                }
            }
            catch (IllegalStateException e) {
                logger.info("Session appears to be invalidated, ignore");
                logger.trace("", (Throwable)e);
            }
            sbean.setObjectCount(attributeCount);
            sbean.setSize(size);
            sbean.setSerializable(sessionSerializable);
        }
        return sbean;
    }

    public static List<Attribute> getApplicationAttributes(Context context) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        ServletContext servletCtx = context.getServletContext();
        for (String attrName : Collections.list(servletCtx.getAttributeNames())) {
            Object attrValue = servletCtx.getAttribute(attrName);
            Attribute attr = new Attribute();
            attr.setName(attrName);
            attr.setValue(attrValue);
            attr.setType(ClassUtils.getQualifiedName(attrValue.getClass()));
            attrs.add(attr);
        }
        return attrs;
    }

    public static List<ApplicationParam> getApplicationInitParams(Context context, ContainerWrapperBean containerWrapper) {
        return containerWrapper.getTomcatContainer().getApplicationInitParams(context);
    }

    public static ServletInfo getApplicationServlet(Context context, String servletName) {
        Container container = context.findChild(servletName);
        if (container instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)container;
            return ApplicationUtils.getServletInfo(wrapper, context.getName());
        }
        return null;
    }

    private static ServletInfo getServletInfo(Wrapper wrapper, String contextName) {
        ServletInfo si = new ServletInfo();
        si.setApplicationName(contextName.length() > 0 ? contextName : "/");
        si.setServletName(wrapper.getName());
        si.setServletClass(wrapper.getServletClass());
        si.setAvailable(!wrapper.isUnavailable());
        si.setLoadOnStartup(wrapper.getLoadOnStartup());
        si.setRunAs(wrapper.getRunAs());
        si.getMappings().addAll(Arrays.asList(wrapper.findMappings()));
        if (wrapper instanceof StandardWrapper) {
            StandardWrapper sw = (StandardWrapper)wrapper;
            si.setAllocationCount(sw.getCountAllocated());
            si.setErrorCount(sw.getErrorCount());
            si.setLoadTime(sw.getLoadTime());
            si.setMaxInstances(sw.getMaxInstances());
            si.setMaxTime(sw.getMaxTime());
            si.setMinTime(sw.getMinTime() == Long.MAX_VALUE ? 0L : sw.getMinTime());
            si.setProcessingTime(sw.getProcessingTime());
            si.setRequestCount(sw.getRequestCount());
            try {
                Object singleThreaded = MethodUtils.invokeMethod((Object)sw, (String)"isSingleThreadModel");
                if (singleThreaded == null) {
                    si.setSingleThreaded(false);
                } else {
                    si.setSingleThreaded(Boolean.parseBoolean(String.valueOf(singleThreaded)));
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error("Cannot determine single threading");
                logger.trace("", (Throwable)e);
            }
        }
        return si;
    }

    public static List<ServletInfo> getApplicationServlets(Context context) {
        Container[] cns = context.findChildren();
        ArrayList<ServletInfo> servlets = new ArrayList<ServletInfo>(cns.length);
        for (Container container : cns) {
            if (!(container instanceof Wrapper)) continue;
            Wrapper wrapper = (Wrapper)container;
            servlets.add(ApplicationUtils.getServletInfo(wrapper, context.getName()));
        }
        return servlets;
    }

    public static List<ServletMapping> getApplicationServletMaps(Context context) {
        String[] sms = context.findServletMappings();
        ArrayList<ServletMapping> servletMaps = new ArrayList<ServletMapping>(sms.length);
        for (String servletMapping : sms) {
            String sn;
            if (servletMapping == null || (sn = context.findServletMapping(servletMapping)) == null) continue;
            ServletMapping sm = new ServletMapping();
            sm.setApplicationName(context.getName().length() > 0 ? context.getName() : "/");
            sm.setUrl(servletMapping);
            sm.setServletName(sn);
            Container container = context.findChild(sn);
            if (container instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)container;
                sm.setServletClass(wrapper.getServletClass());
                sm.setAvailable(!wrapper.isUnavailable());
            }
            servletMaps.add(sm);
        }
        return servletMaps;
    }

    public static List<FilterInfo> getApplicationFilters(Context context, ContainerWrapperBean containerWrapper) {
        return containerWrapper.getTomcatContainer().getApplicationFilters(context);
    }
}

