/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import psiprobe.tools.Accessor;
import psiprobe.tools.AccessorFactory;
import psiprobe.tools.ObjectWrapper;

public class Instruments {
    public static final long SIZE_VOID = 0L;
    public static final long SIZE_BOOLEAN = 1L;
    public static final long SIZE_BYTE = 1L;
    public static final long SIZE_CHAR = 2L;
    public static final long SIZE_SHORT = 2L;
    public static final long SIZE_INT = 4L;
    public static final long SIZE_LONG = 8L;
    public static final long SIZE_FLOAT = 4L;
    public static final long SIZE_DOUBLE = 8L;
    public static final long SIZE_OBJECT = 8L;
    public static final long SIZE_REFERENCE;
    private static final Accessor ACCESSOR;
    private static final boolean IGNORE_NIO;
    private Set<Object> processedObjects = new HashSet<Object>(2048);
    private final List<Object> thisQueue = new LinkedList<Object>();
    private final List<Object> nextQueue = new LinkedList<Object>();
    private ClassLoader classLoader = null;

    public static long sizeOf(Object obj) {
        return new Instruments().internalSizeOf(obj);
    }

    public static long sizeOf(Object obj, ClassLoader cl) {
        Instruments instruments = new Instruments();
        instruments.classLoader = cl;
        return instruments.internalSizeOf(obj);
    }

    public static long sizeOf(Object obj, Set<Object> objects) {
        Instruments instruments = new Instruments();
        instruments.processedObjects = objects;
        return instruments.internalSizeOf(obj);
    }

    private long internalSizeOf(Object root) {
        long size = 0L;
        this.thisQueue.add(root);
        while (!this.thisQueue.isEmpty()) {
            Iterator<Object> it = this.thisQueue.iterator();
            while (it.hasNext()) {
                ObjectWrapper ow;
                Object obj = it.next();
                if (!(!Instruments.isInitialized() || obj == null || this.classLoader != null && this.classLoader != obj.getClass().getClassLoader() || IGNORE_NIO && obj.getClass().getName().startsWith("java.nio.") || this.processedObjects.contains(ow = new ObjectWrapper(obj)))) {
                    if (obj.getClass().isArray()) {
                        size += this.sizeOfArray(obj);
                    } else if (obj.getClass().isPrimitive()) {
                        size += Instruments.sizeOfPrimitive(obj.getClass());
                    } else {
                        this.processedObjects.add(ow);
                        size += this.sizeOfObject(obj);
                    }
                }
                it.remove();
            }
            if (this.nextQueue.isEmpty()) continue;
            this.thisQueue.addAll(this.nextQueue);
            this.nextQueue.clear();
        }
        return size;
    }

    private long sizeOfObject(Object obj) {
        long size = 8L;
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                if (field.getType().isPrimitive()) {
                    size += Instruments.sizeOfPrimitive(field.getType());
                    continue;
                }
                Object val = ACCESSOR.get(obj, field);
                if (field.getType().isArray()) {
                    size += this.sizeOfArray(val);
                    continue;
                }
                size += SIZE_REFERENCE;
                this.nextQueue.add(val);
            }
        }
        return size;
    }

    private long sizeOfArray(Object obj) {
        if (obj != null) {
            Class<?> ct = obj.getClass().getComponentType();
            if (ct.isPrimitive()) {
                return (long)Array.getLength(obj) * Instruments.sizeOfPrimitive(ct);
            }
            for (int i = 0; i < Array.getLength(obj); ++i) {
                this.nextQueue.add(Array.get(obj, i));
            }
        }
        return 0L;
    }

    private static <T> long sizeOfPrimitive(Class<T> type) {
        if (type == Boolean.TYPE) {
            return 1L;
        }
        if (type == Byte.TYPE) {
            return 1L;
        }
        if (type == Character.TYPE) {
            return 2L;
        }
        if (type == Short.TYPE) {
            return 2L;
        }
        if (type == Integer.TYPE) {
            return 4L;
        }
        if (type == Long.TYPE) {
            return 8L;
        }
        if (type == Float.TYPE) {
            return 4L;
        }
        if (type == Double.TYPE) {
            return 8L;
        }
        if (type == Void.TYPE) {
            return 0L;
        }
        return SIZE_REFERENCE;
    }

    public static boolean isInitialized() {
        return ACCESSOR != null;
    }

    public static Object getField(Object obj, String name) {
        Field field;
        if (Instruments.isInitialized() && (field = Instruments.findField(obj.getClass(), name)) != null) {
            return ACCESSOR.get(obj, field);
        }
        return null;
    }

    public static <T> Field findField(Class<T> clazz, String name) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        Class<T> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return Instruments.findField(superClass, name);
        }
        return null;
    }

    static {
        ACCESSOR = AccessorFactory.getInstance();
        String ignoreNioProp = System.getProperty("psiprobe.intruments.ignoreNIO");
        String os64bitProp = System.getProperty("sun.arch.data.model");
        IGNORE_NIO = ignoreNioProp == null || "true".equalsIgnoreCase(ignoreNioProp);
        SIZE_REFERENCE = "64".equals(os64bitProp) ? 8L : 4L;
    }
}

