/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxTools {
    private static final Logger logger = LoggerFactory.getLogger(JmxTools.class);

    private JmxTools() {
    }

    public static Object getAttribute(MBeanServer mbeanServer, ObjectName objName, String attrName) throws Exception {
        try {
            return mbeanServer.getAttribute(objName, attrName);
        }
        catch (AttributeNotFoundException e) {
            logger.error("{} does not have '{}' attribute", (Object)objName, (Object)attrName);
            logger.trace("", (Throwable)e);
            return null;
        }
    }

    public static Object invoke(MBeanServer mbeanServer, ObjectName objName, String method, Object[] o, String[] s) throws Exception {
        try {
            return mbeanServer.invoke(objName, method, o, s);
        }
        catch (Exception e) {
            logger.error("{} does not have '{}' attribute", (Object)objName, (Object)method);
            logger.trace("", (Throwable)e);
            return null;
        }
    }

    public static long getLongAttr(MBeanServer mbeanServer, ObjectName objName, String attrName, long defaultValue) {
        try {
            Object obj = mbeanServer.getAttribute(objName, attrName);
            return obj == null ? defaultValue : (Long)obj;
        }
        catch (Exception e) {
            logger.trace("", (Throwable)e);
            return defaultValue;
        }
    }

    public static long getLongAttr(CompositeData cds, String name) {
        Object obj = cds.get(name);
        if (obj != null && obj instanceof Long) {
            return (Long)obj;
        }
        return 0L;
    }

    public static long getLongAttr(MBeanServer mbeanServer, ObjectName objName, String attrName) throws Exception {
        return (Long)mbeanServer.getAttribute(objName, attrName);
    }

    public static int getIntAttr(MBeanServer mbeanServer, ObjectName objName, String attrName) throws Exception {
        return (Integer)mbeanServer.getAttribute(objName, attrName);
    }

    public static int getIntAttr(CompositeData cds, String name, int defaultValue) {
        Object obj = cds.get(name);
        if (obj != null && obj instanceof Integer) {
            return (Integer)obj;
        }
        return defaultValue;
    }

    public static String getStringAttr(MBeanServer mbeanServer, ObjectName objName, String attrName) throws Exception {
        Object obj = JmxTools.getAttribute(mbeanServer, objName, attrName);
        return obj == null ? null : obj.toString();
    }

    public static String getStringAttr(CompositeData cds, String name) {
        Object obj = cds.get(name);
        return obj != null ? obj.toString() : null;
    }

    public static boolean getBooleanAttr(CompositeData cds, String name) {
        Object obj = cds.get(name);
        return obj != null && obj instanceof Boolean && (Boolean)obj != false;
    }

    public static boolean hasAttribute(MBeanServer server, ObjectName mbean, String attrName) throws Exception {
        MBeanAttributeInfo[] ai;
        MBeanInfo info = server.getMBeanInfo(mbean);
        for (MBeanAttributeInfo attribInfo : ai = info.getAttributes()) {
            if (!attribInfo.getName().equals(attrName)) continue;
            return true;
        }
        return false;
    }
}

