/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogOutputStream
extends OutputStream {
    private static final Logger INTERNAL_LOGGER = LoggerFactory.getLogger(LogOutputStream.class);
    public static final int LEVEL_OFF = 0;
    public static final int LEVEL_TRACE = 1;
    public static final int LEVEL_DEBUG = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_WARN = 4;
    public static final int LEVEL_ERROR = 5;
    public static final int LEVEL_FATAL = 6;
    private final Logger logger;
    private final int level;
    private final StringBuilder buf = new StringBuilder();

    private LogOutputStream(Logger log, int level) {
        if (log == null) {
            throw new IllegalArgumentException("Log cannot be null");
        }
        this.logger = log;
        this.level = level;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrintStream createPrintStream(Logger log, int level) {
        try (LogOutputStream logStream = new LogOutputStream(log, level);){
            PrintStream printStream = new PrintStream((OutputStream)logStream, true, StandardCharsets.UTF_8.name());
            return printStream;
        }
        catch (IOException e) {
            INTERNAL_LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public void flush() {
        if (this.shouldWrite()) {
            String message = this.buf.toString();
            this.log(message);
        }
        this.buf.setLength(0);
    }

    @Override
    public void write(int out) {
        if (this.shouldWrite()) {
            char chr = (char)out;
            this.buf.append(chr);
        }
    }

    public Logger getLog() {
        return this.logger;
    }

    public int getLevel() {
        return this.level;
    }

    private boolean shouldWrite() {
        switch (this.level) {
            case 1: {
                return this.logger.isTraceEnabled();
            }
            case 2: {
                return this.logger.isDebugEnabled();
            }
            case 3: {
                return this.logger.isInfoEnabled();
            }
            case 4: {
                return this.logger.isWarnEnabled();
            }
            case 5: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    private void log(String message) {
        if (message == null || "".equals(message)) {
            return;
        }
        switch (this.level) {
            case 1: {
                this.logger.trace(message);
                break;
            }
            case 2: {
                this.logger.debug(message);
                break;
            }
            case 3: {
                this.logger.info(message);
                break;
            }
            case 4: {
                this.logger.warn(message);
                break;
            }
            case 5: {
                this.logger.error(message);
                break;
            }
        }
    }
}

