/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;

public class MailMessage {
    private final List<String> to = new ArrayList<String>();
    private final List<String> cc = new ArrayList<String>();
    private final List<String> bcc = new ArrayList<String>();
    private final List<DataSource> attachments = new ArrayList<DataSource>();
    private String subject = "";
    private String body = "";
    private boolean bodyHtml;

    public MailMessage(String to, String subject, String body) {
        this.addRecipientTo(to);
        this.setSubject(subject);
        this.setBody(body);
    }

    public String[] getToArray() {
        return this.to.toArray(new String[this.to.size()]);
    }

    public String[] getCcArray() {
        return this.cc.toArray(new String[this.cc.size()]);
    }

    public String[] getBccArray() {
        return this.bcc.toArray(new String[this.bcc.size()]);
    }

    public DataSource[] getAttachmentsArray() {
        return this.attachments.toArray(new DataSource[this.attachments.size()]);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isBodyHtml() {
        return this.bodyHtml;
    }

    public MailMessage addRecipientTo(String address) {
        if (address != null) {
            this.to.add(address);
        }
        return this;
    }

    public MailMessage addRecipientCc(String address) {
        if (address != null) {
            this.cc.add(address);
        }
        return this;
    }

    public MailMessage addRecipientBcc(String address) {
        if (address != null) {
            this.bcc.add(address);
        }
        return this;
    }

    public MailMessage addAttachment(File attachment) {
        FileDataSource ds = new FileDataSource(attachment);
        return this.addAttachment((DataSource)ds);
    }

    public MailMessage addAttachment(DataSource attachment) {
        if (attachment != null) {
            this.attachments.add(attachment);
        }
        return this;
    }

    public MailMessage clearRecipientsTo() {
        this.to.clear();
        return this;
    }

    public MailMessage clearRecipientsCc() {
        this.cc.clear();
        return this;
    }

    public MailMessage clearRecipientsBcc() {
        this.bcc.clear();
        return this;
    }

    public MailMessage clearAttachments() {
        this.attachments.clear();
        return this;
    }

    public MailMessage setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public MailMessage setBody(String body) {
        this.body = body;
        return this;
    }

    public MailMessage setBodyHtml(boolean bodyHtml) {
        this.bodyHtml = bodyHtml;
        return this;
    }

    protected List<String> getTo() {
        return this.to;
    }

    protected List<String> getCc() {
        return this.cc;
    }

    protected List<String> getBcc() {
        return this.bcc;
    }

    protected List<DataSource> getAttachments() {
        return this.attachments;
    }
}

