/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import psiprobe.tools.LogOutputStream;
import psiprobe.tools.MailMessage;

public class Mailer {
    public static final String PROPERTY_KEY_SMTP = "mail.smtp.host";
    private static final Logger logger = LoggerFactory.getLogger(Mailer.class);
    private String from;
    private String smtp;
    private String defaultTo;
    private String subjectPrefix;

    public Mailer() {
        this(null);
    }

    public Mailer(String from) {
        this(from, null);
    }

    public Mailer(String from, String smtp) {
        this.smtp = smtp;
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSmtp() {
        if (this.smtp == null) {
            return System.getProperty(PROPERTY_KEY_SMTP);
        }
        return this.smtp;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSmtp(String smtp) {
        this.smtp = smtp;
    }

    public String getDefaultTo() {
        return this.defaultTo;
    }

    @Value(value="${psiprobe.tools.mail.to}")
    public void setDefaultTo(String defaultTo) {
        this.defaultTo = defaultTo;
    }

    public String getSubjectPrefix() {
        return this.subjectPrefix;
    }

    @Value(value="${psiprobe.tools.mail.subjectPrefix}")
    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public void send(MailMessage mailMessage) throws MessagingException {
        Properties props = (Properties)System.getProperties().clone();
        if (this.smtp != null) {
            props.put(PROPERTY_KEY_SMTP, this.smtp);
        }
        try (PrintStream debugOut = LogOutputStream.createPrintStream(logger, 2);){
            Session session = Session.getDefaultInstance((Properties)props);
            session.setDebug(true);
            session.setDebugOut(debugOut);
            MimeMessage message = this.createMimeMessage(session, mailMessage);
            logger.debug("Sending message");
            Transport.send((Message)message);
        }
    }

    private MimeMessage createMimeMessage(Session session, MailMessage mailMessage) throws MessagingException {
        DataSource[] attachments;
        String subject = mailMessage.getSubject();
        if (this.subjectPrefix != null && !this.subjectPrefix.isEmpty()) {
            subject = this.subjectPrefix + " " + subject;
        }
        MimeMultipart content = new MimeMultipart("related");
        for (DataSource attachment : attachments = mailMessage.getAttachmentsArray()) {
            MimeBodyPart attachmentPart = Mailer.createAttachmentPart(attachment);
            content.addBodyPart((BodyPart)attachmentPart);
        }
        MimeBodyPart bodyPart = Mailer.createMessageBodyPart(mailMessage.getBody(), mailMessage.isBodyHtml());
        content.addBodyPart((BodyPart)bodyPart);
        MimeMessage message = new MimeMessage(session);
        if (this.from == null) {
            message.setFrom();
        } else {
            message.setFrom((Address)new InternetAddress(this.from));
        }
        InternetAddress[] to = Mailer.createAddresses(mailMessage.getToArray());
        if (to.length == 0) {
            to = InternetAddress.parse((String)this.defaultTo);
        }
        message.setRecipients(Message.RecipientType.TO, (Address[])to);
        InternetAddress[] cc = Mailer.createAddresses(mailMessage.getCcArray());
        message.setRecipients(Message.RecipientType.CC, (Address[])cc);
        InternetAddress[] bcc = Mailer.createAddresses(mailMessage.getBccArray());
        message.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
        message.setSubject(subject);
        message.setContent((Multipart)content);
        return message;
    }

    private static InternetAddress[] createAddresses(String[] addresses) throws AddressException {
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>(addresses.length);
        for (String address : addresses) {
            InternetAddress[] parsedAddresses = InternetAddress.parse((String)address);
            result.addAll(Arrays.asList(parsedAddresses));
        }
        return result.toArray(new InternetAddress[result.size()]);
    }

    private static MimeBodyPart createAttachmentPart(DataSource attachment) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        attachmentPart.setDataHandler(new DataHandler(attachment));
        attachmentPart.setDisposition("attachment");
        attachmentPart.setFileName(attachment.getName());
        return attachmentPart;
    }

    private static MimeBodyPart createMessageBodyPart(String body, boolean html) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setText(body);
        bodyPart.setHeader("content-type", html ? "text/html" : "text/plain");
        return bodyPart;
    }
}

