/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.tools.Accessor;

public class ReflectiveAccessor
implements Accessor {
    private static final Logger logger = LoggerFactory.getLogger(ReflectiveAccessor.class);
    private static Object reflectionFactory;
    private static Method newFieldAccessor;
    private static Method get;

    ReflectiveAccessor() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException, SecurityException {
        ReflectiveAccessor.init();
    }

    @Override
    public Object get(Object obj, Field field) {
        try {
            Object fieldAccessor = ReflectiveAccessor.getFieldAccessor(field);
            if (fieldAccessor != null) {
                return get.invoke(fieldAccessor, obj);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.trace("", (Throwable)e);
        }
        return null;
    }

    private static Object getFieldAccessor(Field field) throws IllegalAccessException, InvocationTargetException {
        if (newFieldAccessor.getParameterTypes().length == 1) {
            return newFieldAccessor.invoke(reflectionFactory, field);
        }
        return newFieldAccessor.invoke(reflectionFactory, field, Boolean.TRUE);
    }

    private static void init() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException, SecurityException {
        String vmVendor = System.getProperty("java.vm.vendor");
        if (vmVendor != null && (vmVendor.contains("Sun Microsystems") || vmVendor.contains("Apple Computer") || vmVendor.contains("Apple Inc.") || vmVendor.contains("IBM Corporation"))) {
            reflectionFactory = ReflectiveAccessor.getReflectionFactory();
            Class[] paramTypes = new Class[]{Field.class, Boolean.TYPE};
            newFieldAccessor = reflectionFactory.getClass().getMethod("newFieldAccessor", paramTypes);
            get = newFieldAccessor.getReturnType().getMethod("get", Object.class);
        }
    }

    private static Object getReflectionFactory() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> getReflectionFactoryActionClass = Class.forName("sun.reflect.ReflectionFactory$GetReflectionFactoryAction");
        PrivilegedAction getReflectionFactoryAction = (PrivilegedAction)getReflectionFactoryActionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return AccessController.doPrivileged(getReflectionFactoryAction);
    }
}

