/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityUtils {
    private SecurityUtils() {
    }

    public static boolean hasAttributeValueRole(ServletContext servletContext, HttpServletRequest request) {
        String[] privilegedRoles;
        for (String privilegedRole : privilegedRoles = SecurityUtils.getPrivilegedRoles(servletContext).split(",")) {
            if (!SecurityUtils.userHasRole(privilegedRole)) continue;
            return true;
        }
        return false;
    }

    private static boolean userHasRole(String privilegedRole) {
        Collection authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        boolean result = false;
        for (GrantedAuthority authority : authorities) {
            if (!privilegedRole.equals(authority.getAuthority())) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean userHasRole(String privilegedRole, HttpServletRequest request) {
        return request.isUserInRole(privilegedRole);
    }

    private static String getPrivilegedRoles(ServletContext servletContext) {
        return servletContext.getInitParameter("attribute.value.roles");
    }
}

