/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.tools.AsyncSocketFactory;
import psiprobe.tools.url.UrlParser;

public final class Whois {
    private static final Logger logger = LoggerFactory.getLogger(Whois.class);

    private Whois() {
    }

    public static Response lookup(String server, int port, String query) throws IOException {
        return Whois.lookup(server, port, query, 5L);
    }

    public static Response lookup(String server, int port, String query, long timeout) throws IOException {
        return Whois.lookup(server, port, query, timeout, System.getProperty("line.separator"));
    }

    public static Response lookup(String server, int port, String query, long timeout, String lineSeparator) throws IOException {
        if (query == null) {
            return null;
        }
        Response response = new Response();
        response.server = server;
        response.port = port;
        try (Socket connection = AsyncSocketFactory.createSocket(server, port, timeout);
             PrintStream out = new PrintStream(connection.getOutputStream(), true, StandardCharsets.UTF_8.name());
             BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            out.println(query);
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                int fs;
                sb.append(line).append(lineSeparator);
                if ((line = line.trim()).startsWith("%") || line.startsWith("#") || (fs = line.indexOf(58)) <= 0) continue;
                String name = line.substring(0, fs);
                String value = line.substring(fs + 1).trim();
                response.data.put(name, value);
            }
            response.summary = sb.toString();
            Response newResponse = null;
            String referral = response.getData().get("ReferralServer");
            if (referral != null) {
                try {
                    UrlParser url = new UrlParser(referral);
                    if ("whois".equals(url.getProtocol())) {
                        newResponse = Whois.lookup(url.getHost(), url.getPort() == -1 ? 43 : url.getPort(), query, timeout, lineSeparator);
                    }
                }
                catch (IOException e) {
                    logger.trace("Could not contact '{}'", (Object)referral, (Object)e);
                }
            }
            if (newResponse != null) {
                response = newResponse;
            }
        }
        return response;
    }

    public static class Response {
        String summary;
        Map<String, String> data = new TreeMap<String, String>();
        String server;
        int port;

        public String getSummary() {
            return this.summary;
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }
    }
}

