/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging.jdk;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import psiprobe.tools.logging.DefaultAccessor;
import psiprobe.tools.logging.LogDestination;
import psiprobe.tools.logging.jdk.Jdk14FileHandlerAccessor;
import psiprobe.tools.logging.jdk.Jdk14HandlerAccessor;
import psiprobe.tools.logging.jdk.JuliHandlerAccessor;

public class Jdk14LoggerAccessor
extends DefaultAccessor {
    private boolean context;

    public List<LogDestination> getHandlers() {
        ArrayList<LogDestination> handlerAccessors = new ArrayList<LogDestination>();
        try {
            Object[] handlers = (Object[])MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getHandlers");
            for (int h = 0; h < handlers.length; ++h) {
                Object handler = handlers[h];
                Jdk14HandlerAccessor handlerAccessor = this.wrapHandler(handler, h);
                if (handlerAccessor == null) continue;
                handlerAccessors.add(handlerAccessor);
            }
        }
        catch (Exception e) {
            logger.error("{}#handlers inaccessible", (Object)this.getTarget().getClass().getName(), (Object)e);
        }
        return handlerAccessors;
    }

    public boolean isContext() {
        return this.context;
    }

    public void setContext(boolean context) {
        this.context = context;
    }

    public boolean isRoot() {
        return "".equals(this.getName()) || this.isJuliRoot();
    }

    public boolean isJuliRoot() {
        return "org.apache.juli.ClassLoaderLogManager$RootLogger".equals(this.getTargetClass());
    }

    public String getName() {
        return (String)this.getProperty(this.getTarget(), "name", null);
    }

    public Jdk14HandlerAccessor getHandler(String logIndex) {
        int index = 0;
        try {
            index = Integer.parseInt(logIndex);
        }
        catch (Exception e) {
            logger.info("Could not parse integer from: {}.  Assuming 0.", (Object)logIndex);
            logger.trace("", (Throwable)e);
        }
        return this.getHandler(index);
    }

    public Jdk14HandlerAccessor getHandler(int index) {
        try {
            Object[] handlers = (Object[])MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getHandlers");
            return this.wrapHandler(handlers[index], index);
        }
        catch (Exception e) {
            logger.error("{}#handlers inaccessible", (Object)this.getTarget().getClass().getName(), (Object)e);
            return null;
        }
    }

    public String getLevel() {
        try {
            Object level = null;
            Object target = this.getTarget();
            while (level == null && target != null) {
                level = this.getLevelInternal(target);
                target = MethodUtils.invokeMethod((Object)target, (String)"getParent");
            }
            if (level == null && this.isJuliRoot()) {
                return "INFO";
            }
            return (String)MethodUtils.invokeMethod(level, (String)"getName");
        }
        catch (Exception e) {
            logger.error("{}#getLevel() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
            return null;
        }
    }

    public void setLevel(String newLevelStr) {
        try {
            Class<?> levelClass = this.getTarget().getClass().getClassLoader().loadClass("java.util.logging.Level");
            Method parse = MethodUtils.getAccessibleMethod(levelClass, (String)"parse", (Class[])new Class[]{String.class});
            Object newLevel = parse.invoke(null, newLevelStr);
            MethodUtils.invokeMethod((Object)this.getTarget(), (String)"setLevel", (Object[])new Object[]{newLevel});
        }
        catch (Exception e) {
            logger.error("{}#setLevel('{}') failed", new Object[]{this.getTarget().getClass().getName(), newLevelStr, e});
        }
    }

    private Object getLevelInternal(Object target) throws Exception {
        return MethodUtils.invokeMethod((Object)target, (String)"getLevel");
    }

    private Jdk14HandlerAccessor wrapHandler(Object handler, int index) {
        try {
            if (handler == null) {
                throw new IllegalArgumentException("handler is null");
            }
            Jdk14HandlerAccessor handlerAccessor = null;
            String className = handler.getClass().getName();
            if ("org.apache.juli.FileHandler".equals(className)) {
                handlerAccessor = new JuliHandlerAccessor();
            } else if ("java.util.logging.ConsoleHandler".equals(className)) {
                handlerAccessor = new Jdk14HandlerAccessor();
            } else if ("java.util.logging.FileHandler".equals(className)) {
                handlerAccessor = new Jdk14FileHandlerAccessor();
            }
            if (handlerAccessor != null) {
                handlerAccessor.setLoggerAccessor(this);
                handlerAccessor.setTarget(handler);
                handlerAccessor.setIndex(Integer.toString(index));
                handlerAccessor.setApplication(this.getApplication());
            }
            return handlerAccessor;
        }
        catch (Exception e) {
            logger.error("Could not wrap handler: '{}'", handler, (Object)e);
            return null;
        }
    }
}

