/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging.jdk;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import psiprobe.tools.logging.DefaultAccessor;
import psiprobe.tools.logging.LogDestination;
import psiprobe.tools.logging.jdk.Jdk14LoggerAccessor;

public class Jdk14ManagerAccessor
extends DefaultAccessor {
    public Jdk14ManagerAccessor(ClassLoader cl) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = cl.loadClass("java.util.logging.LogManager");
        Method getManager = MethodUtils.getAccessibleMethod(clazz, (String)"getLogManager", (Class[])new Class[0]);
        Object manager = getManager.invoke(null, new Object[0]);
        if (manager == null) {
            throw new NullPointerException(clazz.getName() + ".getLogManager() returned null");
        }
        this.setTarget(manager);
    }

    public Jdk14LoggerAccessor getRootLogger() {
        return this.getLogger("");
    }

    public Jdk14LoggerAccessor getLogger(String name) {
        try {
            Object logger = MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getLogger", (Object[])new Object[]{name});
            if (logger == null) {
                throw new NullPointerException(this.getTarget().getClass().getName() + "#getLogger(\"" + name + "\") returned null");
            }
            Jdk14LoggerAccessor accessor = new Jdk14LoggerAccessor();
            accessor.setTarget(logger);
            accessor.setApplication(this.getApplication());
            return accessor;
        }
        catch (Exception e) {
            logger.error("{}#getLogger('{}') failed", new Object[]{this.getTarget().getClass().getName(), name, e});
            return null;
        }
    }

    public List<LogDestination> getHandlers() {
        ArrayList<LogDestination> allHandlers = new ArrayList<LogDestination>();
        try {
            for (String name : Collections.list((Enumeration)MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getLoggerNames"))) {
                Jdk14LoggerAccessor accessor = this.getLogger(name);
                if (accessor == null) continue;
                allHandlers.addAll(accessor.getHandlers());
            }
        }
        catch (Exception e) {
            logger.error("{}#getLoggerNames() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
        }
        return allHandlers;
    }
}

