/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging.log4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import psiprobe.tools.logging.DefaultAccessor;
import psiprobe.tools.logging.log4j.Log4JAppenderAccessor;

public class Log4JLoggerAccessor
extends DefaultAccessor {
    private boolean context;

    public List<Log4JAppenderAccessor> getAppenders() {
        ArrayList<Log4JAppenderAccessor> appenders = new ArrayList<Log4JAppenderAccessor>();
        try {
            for (Object unwrappedAppender : Collections.list((Enumeration)MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getAllAppenders"))) {
                Log4JAppenderAccessor appender = this.wrapAppender(unwrappedAppender);
                if (appender == null) continue;
                appenders.add(appender);
            }
        }
        catch (Exception e) {
            logger.error("{}#getAllAppenders() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
        }
        return appenders;
    }

    public Log4JAppenderAccessor getAppender(String name) {
        try {
            Object appender = MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getAppender", (Object[])new Object[]{name});
            return this.wrapAppender(appender);
        }
        catch (Exception e) {
            logger.error("{}#getAppender() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
            return null;
        }
    }

    public boolean isContext() {
        return this.context;
    }

    public void setContext(boolean context) {
        this.context = context;
    }

    public boolean isRoot() {
        return "root".equals(this.getName()) && "org.apache.log4j.spi.RootLogger".equals(this.getTargetClass());
    }

    public String getName() {
        return (String)this.getProperty(this.getTarget(), "name", null);
    }

    public String getLevel() {
        try {
            Object level = MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getLevel");
            return (String)MethodUtils.invokeMethod((Object)level, (String)"toString");
        }
        catch (Exception e) {
            logger.error("{}#getLevel() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
            return null;
        }
    }

    public void setLevel(String newLevelStr) {
        try {
            Object level = MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getLevel");
            Object newLevel = MethodUtils.invokeMethod((Object)level, (String)"toLevel", (Object[])new Object[]{newLevelStr});
            MethodUtils.invokeMethod((Object)this.getTarget(), (String)"setLevel", (Object[])new Object[]{newLevel});
        }
        catch (Exception e) {
            logger.error("{}#setLevel('{}') failed", new Object[]{this.getTarget().getClass().getName(), newLevelStr, e});
        }
    }

    private Log4JAppenderAccessor wrapAppender(Object appender) {
        try {
            if (appender == null) {
                throw new IllegalArgumentException("appender is null");
            }
            Log4JAppenderAccessor appenderAccessor = new Log4JAppenderAccessor();
            appenderAccessor.setTarget(appender);
            appenderAccessor.setLoggerAccessor(this);
            appenderAccessor.setApplication(this.getApplication());
            return appenderAccessor;
        }
        catch (Exception e) {
            logger.error("Could not wrap appender: {}", appender, (Object)e);
            return null;
        }
    }
}

