/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging.log4j;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import psiprobe.tools.logging.DefaultAccessor;
import psiprobe.tools.logging.log4j.Log4JAppenderAccessor;
import psiprobe.tools.logging.log4j.Log4JLoggerAccessor;

public class Log4JManagerAccessor
extends DefaultAccessor {
    public Log4JManagerAccessor(ClassLoader cl) throws ClassNotFoundException {
        Class<?> clazz = cl.loadClass("org.apache.log4j.LogManager");
        Method exists = MethodUtils.getAccessibleMethod(clazz, (String)"exists", (Class[])new Class[]{String.class});
        if (exists == null) {
            throw new RuntimeException("The LogManager is part of the slf4j bridge.");
        }
        this.setTarget(clazz);
    }

    public Log4JLoggerAccessor getRootLogger() {
        try {
            Class clazz = (Class)this.getTarget();
            Method getRootLogger = MethodUtils.getAccessibleMethod((Class)clazz, (String)"getRootLogger", (Class[])new Class[0]);
            Object logger = getRootLogger.invoke(null, new Object[0]);
            if (logger == null) {
                throw new NullPointerException(this.getTarget().getClass().getName() + "#getRootLogger() returned null");
            }
            Log4JLoggerAccessor accessor = new Log4JLoggerAccessor();
            accessor.setTarget(logger);
            accessor.setApplication(this.getApplication());
            return accessor;
        }
        catch (Exception e) {
            logger.error("{}#getRootLogger() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
            return null;
        }
    }

    public Log4JLoggerAccessor getLogger(String name) {
        try {
            Class clazz = (Class)this.getTarget();
            Method getLogger = MethodUtils.getAccessibleMethod((Class)clazz, (String)"getLogger", (Class[])new Class[]{String.class});
            Object logger = getLogger.invoke(null, name);
            if (logger == null) {
                throw new NullPointerException(this.getTarget().getClass().getName() + "#getLogger(\"" + name + "\") returned null");
            }
            Log4JLoggerAccessor accessor = new Log4JLoggerAccessor();
            accessor.setTarget(logger);
            accessor.setApplication(this.getApplication());
            return accessor;
        }
        catch (Exception e) {
            logger.error("{}#getLogger('{}') failed", new Object[]{this.getTarget().getClass().getName(), name, e});
            return null;
        }
    }

    public List<Log4JAppenderAccessor> getAppenders() {
        ArrayList<Log4JAppenderAccessor> appenders = new ArrayList<Log4JAppenderAccessor>();
        try {
            appenders.addAll(this.getRootLogger().getAppenders());
            Class clazz = (Class)this.getTarget();
            Method getCurrentLoggers = MethodUtils.getAccessibleMethod((Class)clazz, (String)"getCurrentLoggers", (Class[])new Class[0]);
            for (Object currentLogger : Collections.list((Enumeration)getCurrentLoggers.invoke(null, new Object[0]))) {
                Log4JLoggerAccessor accessor = new Log4JLoggerAccessor();
                accessor.setTarget(currentLogger);
                accessor.setApplication(this.getApplication());
                appenders.addAll(accessor.getAppenders());
            }
        }
        catch (Exception e) {
            logger.error("{}#getCurrentLoggers() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
        }
        return appenders;
    }
}

