/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging.log4j2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.MethodUtils;
import psiprobe.tools.logging.DefaultAccessor;
import psiprobe.tools.logging.log4j2.Log4J2AppenderAccessor;
import psiprobe.tools.logging.log4j2.Log4J2LoggerContextAccessor;

public class Log4J2LoggerConfigAccessor
extends DefaultAccessor {
    private boolean context;
    private Log4J2LoggerContextAccessor loggerContext;
    private Map<String, Object> appenderMap;

    @Override
    public void setTarget(Object target) {
        super.setTarget(target);
        try {
            this.appenderMap = (Map)this.invokeMethod(target, "getAppenders", null, null);
        }
        catch (Exception e) {
            logger.error("{}#getAppenders() failed", (Object)target.getClass().getName(), (Object)e);
        }
    }

    public List<Log4J2AppenderAccessor> getAppenders() {
        ArrayList<Log4J2AppenderAccessor> appenders = new ArrayList<Log4J2AppenderAccessor>();
        if (this.appenderMap != null) {
            for (Object unwrappedAppender : this.appenderMap.values()) {
                Log4J2AppenderAccessor appender = this.wrapAppender(unwrappedAppender);
                if (appender == null) continue;
                appenders.add(appender);
            }
        }
        return appenders;
    }

    public Log4J2AppenderAccessor getAppender(String name) {
        if (this.appenderMap != null) {
            Object appender = this.appenderMap.get(name);
            return this.wrapAppender(appender);
        }
        return null;
    }

    public boolean isContext() {
        return this.context;
    }

    public void setContext(boolean context) {
        this.context = context;
    }

    public void setLoggerContext(Log4J2LoggerContextAccessor loggerContext) {
        this.loggerContext = loggerContext;
    }

    public boolean isRoot() {
        return "".equals(this.getName());
    }

    public String getName() {
        return (String)this.getProperty(this.getTarget(), "name", null);
    }

    public String getLevel() {
        try {
            Object level = MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getLevel");
            return (String)MethodUtils.invokeMethod((Object)level, (String)"toString");
        }
        catch (Exception e) {
            logger.error("{}#getLevel() failed", (Object)this.getTarget().getClass().getName(), (Object)e);
            return null;
        }
    }

    public void setLevel(String newLevelStr) {
        try {
            Object level = MethodUtils.invokeMethod((Object)this.getTarget(), (String)"getLevel");
            Object newLevel = MethodUtils.invokeMethod((Object)level, (String)"toLevel", (Object[])new Object[]{newLevelStr});
            MethodUtils.invokeMethod((Object)this.getTarget(), (String)"setLevel", (Object[])new Object[]{newLevel});
            this.loggerContext.updateLoggers();
        }
        catch (Exception e) {
            logger.error("{}#setLevel('{}') failed", new Object[]{this.getTarget().getClass().getName(), newLevelStr, e});
        }
    }

    private Log4J2AppenderAccessor wrapAppender(Object appender) {
        try {
            if (appender == null) {
                throw new IllegalArgumentException("appender is null");
            }
            Log4J2AppenderAccessor appenderAccessor = new Log4J2AppenderAccessor();
            appenderAccessor.setTarget(appender);
            appenderAccessor.setLoggerAccessor(this);
            appenderAccessor.setApplication(this.getApplication());
            return appenderAccessor;
        }
        catch (Exception e) {
            logger.error("Could not wrap appender: {}", appender, (Object)e);
            return null;
        }
    }
}

