/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.logging.logback;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import psiprobe.tools.logging.DefaultAccessor;
import psiprobe.tools.logging.logback.LogbackAppenderAccessor;
import psiprobe.tools.logging.logback.LogbackLoggerAccessor;

public class LogbackFactoryAccessor
extends DefaultAccessor {
    public LogbackFactoryAccessor(ClassLoader cl) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = cl.loadClass("org.slf4j.impl.StaticLoggerBinder");
        Method getSingleton = MethodUtils.getAccessibleMethod(clazz, (String)"getSingleton", (Class[])new Class[0]);
        Object singleton = getSingleton.invoke(null, new Object[0]);
        Method getLoggerFactory = MethodUtils.getAccessibleMethod(clazz, (String)"getLoggerFactory", (Class[])new Class[0]);
        Object loggerFactory = getLoggerFactory.invoke(singleton, new Object[0]);
        Class<?> loggerFactoryClass = cl.loadClass("ch.qos.logback.classic.LoggerContext");
        if (!loggerFactoryClass.isInstance(loggerFactory)) {
            throw new RuntimeException("The singleton SLF4J binding was not Logback");
        }
        this.setTarget(loggerFactory);
    }

    public LogbackLoggerAccessor getRootLogger() {
        return this.getLogger("ROOT");
    }

    public LogbackLoggerAccessor getLogger(String name) {
        try {
            Class<?> clazz = this.getTarget().getClass();
            Method getLogger = MethodUtils.getAccessibleMethod(clazz, (String)"getLogger", (Class[])new Class[]{String.class});
            Object logger = getLogger.invoke(this.getTarget(), name);
            if (logger == null) {
                throw new NullPointerException(this.getTarget() + ".getLogger(\"" + name + "\") returned null");
            }
            LogbackLoggerAccessor accessor = new LogbackLoggerAccessor();
            accessor.setTarget(logger);
            accessor.setApplication(this.getApplication());
            return accessor;
        }
        catch (Exception e) {
            logger.error("{}.getLogger('{}') failed", new Object[]{this.getTarget(), name, e});
            return null;
        }
    }

    public List<LogbackAppenderAccessor> getAppenders() {
        ArrayList<LogbackAppenderAccessor> appenders = new ArrayList<LogbackAppenderAccessor>();
        try {
            Class<?> clazz = this.getTarget().getClass();
            Method getLoggerList = MethodUtils.getAccessibleMethod(clazz, (String)"getLoggerList", (Class[])new Class[0]);
            List loggers = (List)getLoggerList.invoke(this.getTarget(), new Object[0]);
            for (Object logger : loggers) {
                LogbackLoggerAccessor accessor = new LogbackLoggerAccessor();
                accessor.setTarget(logger);
                accessor.setApplication(this.getApplication());
                appenders.addAll(accessor.getAppenders());
            }
        }
        catch (Exception e) {
            logger.error("{}.getLoggerList() failed", this.getTarget(), (Object)e);
        }
        return appenders;
    }
}

