/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.tools.url;

import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlParser {
    private static final Logger logger = LoggerFactory.getLogger(UrlParser.class);
    private String protocol;
    private String host;
    private int port = -1;
    private String path;

    public UrlParser(String url) throws MalformedURLException {
        if (url != null && url.length() > 0) {
            String hostport;
            int ppos = url.indexOf("://");
            if (ppos >= 0) {
                this.protocol = url.substring(0, ppos);
                url = url.substring(ppos + 3);
            }
            if ((ppos = url.indexOf(47)) >= 0) {
                hostport = url.substring(0, ppos);
                this.path = url.substring(ppos + 1);
            } else {
                hostport = url;
            }
            ppos = hostport.indexOf(58);
            if (ppos >= 0) {
                this.host = hostport.substring(0, ppos);
                String portString = hostport.substring(ppos + 1);
                try {
                    this.port = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    logger.trace("", (Throwable)e);
                    throw new MalformedURLException("Invalid port " + portString);
                }
            } else {
                this.host = hostport;
            }
        } else {
            throw new MalformedURLException("Empty URL");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

